<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;

class CreateMarchiDayRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        $conditions=[
            'day_date' => "bail|required|date_format:d/m/Y",
        ];
        foreach($this->input() as $key=>$value){
            if(substr($key,0,18)=="product_min_price_"){
                if($this->input("product_check_".substr($key,18,(strlen($key)-18)))){
                    $conditions[$key]="bail|required|integer";
                }
            }
            if(substr($key,0,18)=="product_max_price_"){
                if($this->input("product_check_".substr($key,18,(strlen($key)-18)))){
                    $conditions[$key]="bail|required|integer|gte:product_min_price_".substr($key,18,(strlen($key)-18));
                }
            }
        }

        return $conditions;
    }

    public function attributes(){

        $attrs=[];
        $attrs["day_date"]="Date";
        foreach($this->input() as $key=>$value){
            if(substr($key,0,18)=="product_min_price_"){
                $attrs[$key]="Prix Min";
            }
            if(substr($key,0,18)=="product_max_price_"){
                $attrs[$key]="Prix Max";
            }
        }
        return $attrs;
    }
}
