<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;

class CreateMarchiCategoryRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        return [
            'title' => "bail|required|max:500",
            'img'=>"bail|required|max:500",
            'summary'=>"bail|required",
            'meta_description'=>"bail|required",
            'meta_title'=>"bail|required|max:500",
            'meta_keywords'=>"bail|required",
        ];
    }

    public function attributes(){
        return [
            "title"=>"Titre",
            "meta_title"=>"Titre Seo",
            "meta_keywords"=>"Mots Clés",
            "img"=>"Image",
            "summary"=>"Déscription",
            "meta_description"=>"Déscription SEO",
        ];
    }
}
