<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;

class CreateKidsStoryRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        $conditions=[
            'category' => "bail|required",
            'title' => "bail|required|max:1000",
            'summary' => "bail|required|max:1000",
            'img' => "bail|required",
            'youtube_url' => "bail|required|url",
        ];
        return $conditions;
    }
}
