<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Http\Requests\CreateUserRequest;
use App\Http\Requests\EditUserRequest;
use App\Http\Requests\ChangePasswordRequest;
use App\User;
use App\Role;

class UserController extends Controller
{
    /**
     * Create a new controller instance.
     *
     * @return void
     */
    public function __construct()
    {
        
    }

    public function getUser(){
    	return "hello";
    }

    /**
     * list users
     * @return void
     */
    public function index(){
    	$users=User::with("roles")->get();
    	return view('users.list',compact('users'));
    }

    /**
     * desactivate user
     * @param Request $request
     * @return json
     */
    public function desactivate(Request $request){
        $user=User::find($request->id);
        $user->status=0;
        $user->save();
        return response()->json(['success'=>"l'utilisateur ".$user->name." a été désactivé avec succès"]);
    }

    /**
     * activate user
     * @param Request $request
     * @return json
     */
    public function activate(Request $request){
        $user=User::find($request->id);
        $user->status=1;
        $user->is_two_factor_enabled=0;
        $user->two_factor_provisioned_uri="";
        $user->remember_token="";
        $user->save();
        return response()->json(['success'=>"l'utilisateur ".$user->name." a été activé avec succès"]);
    }

    /**
     * create new user
     * 
     * @return void
     */
    public function newUser(){
        $roles=Role::all();
        return view('users.create')->with(compact('roles'));
    }

    /**
     * create new user ajax request
     * 
     * @param Request $request
     * @return void
     */
    public function ajxNewUser(CreateUserRequest $request){

        $user=new User();
        $user->email=$request->get("email");
        $user->password=bcrypt($request->get("password"));
        $user->name=$request->get("name");
        $user->save();

        if(is_array($request->get("roles"))){
            foreach($request->get("roles") as $roleID){
                $role=Role::find($roleID);
                $user->roles()->attach($role);
            }
        }elseif($request->get("roles")){
            $role=Role::find($request->get("roles"));
            $user->roles()->attach($role);
        }
        
        return response()->json(['redirect'=>route('usersList')]);
    }

    /**
     * edit user form
     * 
     * @param int $userId
     * @return void
     */
    public function edit($userId){
        $user=User::find($userId);
        $roles=Role::all();
        return view('users.edit')->with(compact("user"))
            ->with(compact("roles"));
    }

    /**
     * update user
     * 
     * @param EditUserRequest $request
     * @param int $userId
     * @return void
     */
    public function ajxUpdateUser(EditUserRequest $request,$userId){
        $user=User::find($userId);
        $user->email=$request->get("email");
        $user->name=$request->get("name");
        $user->save();
        $user->roles()->detach();
        if(is_array($request->get("roles"))){
            foreach($request->get("roles") as $roleID){
                $role=Role::find($roleID);
                $user->roles()->attach($role);
            }
        }elseif($request->get("roles")){
            $role=Role::find($request->get("roles"));
            $user->roles()->attach($role);
        }

        return response()->json(['redirect'=>route('usersList')]);

    }

    /**
     * change password form
     * 
     * @param int $userId
     * @return void
     */
    public function editPassword($userId){
        $user=User::find($userId);
        return view('users.editPassword')->with(compact('user'));
    }

    /**
     * update user password
     * 
     * @param ChangePasswordRequest $request
     * @param int $userId
     * @return void
     */
    public function ajxUpdateUserPassword(ChangePasswordRequest $request,$userId){
        $user=User::find($userId);
        $user->password=bcrypt($request->get("password"));
        $user->save();
        
        return response()->json(['redirect'=>route('usersList')]);
    }


}
