<?php

namespace App\Http\Controllers;

use App\Post;
use App\Tag;
use App\TagsPredefinis;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;

class TagsController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $tags = TagsPredefinis::latest()->paginate(5);

        return view('tags.index',compact('tags'))
            ->with('i', (request()->input('page', 1) - 1) * 5);
    }


    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        return view('tags.create');
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $request->validate([
            'name' => 'required'
        ]);

        TagsPredefinis::create($request->all());

        return redirect()->route('tags.index')
            ->with('success','Tags created successfully.');
    }

    /**
     * Display the specified resource.
     *
     * @param  \App\TagsPredefinis  $tags
     * @return \Illuminate\Http\Response
     */
    public function show(TagsPredefinis $tags)
    {
        return view('tags.show',compact('tags'));
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  \App\TagsPredefinis  $tags
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $tags = TagsPredefinis::find($id);

        return view('tags.edit', compact('tags'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \App\TagsPredefinis  $tags
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        $request->validate([
            'name'=>'required'
        ]);

        $tags = TagsPredefinis::find($id);
        $tags->name = $request->get('name');
        $tags->save();

        return redirect('/tags')->with('success', 'Tags has been updated');
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  \App\TagsPredefinis  $tags
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        $share = TagsPredefinis::find($id);
        $share->delete();

        return redirect('/tags')->with('success', 'Tags has been deleted Successfully');
    }
        /**
     * search for list
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function ajaxList(Request $request){
        $list=Tag::where('title','LIKE','%'.$request->get("term").'%')->get();
        $items=[];
        foreach($list as $line){
            $items[]=["id"=>$line->id,"text"=>$line->title];
        }
        return response()->json($items);
    }


    public function getAllTagsCleanUp(){
        $tags = DB::table('tags')->select('title',DB::raw('count(*) as occurences'))
            ->groupBy('title')
            ->having(DB::raw('count(*)'),'>','1')
            ->orderBy('occurences','desc')->get();
        return view('tags.clean',compact('tags'));
    }
    public function FixTags($tagName){
//        $tagName = urldecode($nameOfTag);
        dump($tagName);
//         $tags = Tag::where('title','regexp',"^[+,/,-, ]?$tagName{1,}")->get();
          $editedTagId = Tag::where('title',$tagName)->first()->id;
          dump($editedTagId);
         $tagsPostsIds = DB::table('tag_post')
            ->select('tag_post.id')
            ->join('tags','tag_post.tag_id','=','tags.id')
            ->where('title','regexp',"^[+,/,-, ]?$tagName{1,}")
             ->orWhere('title',$tagName)
            ->get()
            ->pluck('id');
         dump($tagsPostsIds);
        DB::table('tag_post')->whereIn('id',$tagsPostsIds)->update(['tag_id'=>$editedTagId]);
        DB::table('tags')
            ->where(function ($query) use($tagName){
                    $query->where('title','regexp',"^[+,/,-, ]?$tagName{1,}");
                    $query->orWhere('title',$tagName);
                })
            ->where('id','!=',$editedTagId)
            ->delete();
        return "updated" . $tagName;
    }
}
