<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Http\Requests\CreateUserRequest;
use App\Http\Requests\EditUserRequest;
use App\Http\Requests\ChangePasswordRequest;
use App\User;
use App\Role;
use App\Utilisateur;

class SocialUserController extends Controller{

    /**
     * Create a new controller instance.
     *
     * @return void
     */
    public function __construct()
    {
        
    }


    /**
     * list users
     * @return void
     */
    public function index(){
    	$users=Utilisateur::get();
    	return view('social-users.list',compact('users'));
    }

    /**
     * desactivate user
     * @param Request $request
     * @return json
     */
    public function desactivate(Request $request){
        $user=Utilisateur::find($request->id);
        $user->status=0;
        $user->save();
        return response()->json(['success'=>"l'utilisateur ".$user->name." a été désactivé avec succès"]);
    }

    /**
     * activate user
     * @param Request $request
     * @return json
     */
    public function activate(Request $request){
        $user=Utilisateur::find($request->id);
        $user->status=1;
        $user->save();
        return response()->json(['success'=>"l'utilisateur ".$user->name." a été activé avec succès"]);
    }
}