<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\SitemapIndex;
use Laravelium\Sitemap\Sitemap;
use Laravelium\Sitemap\SitemapServiceProvider;
use App\SitemapLink;



class SitemapController extends Controller
{
    /**
     * index
     * @return void
     */

    public function SitemapIndex(){
        $sitemapIndexes = SitemapIndex::get();
        // create sitemap
        $sitemap = \App::make('sitemap');
        //$sitemap->setCache('laravel.sitemapindex', 3600);
        foreach ($sitemapIndexes as $sitemapIndex) {
            $sitemap->addSitemap("diwanfm.net/sitemap-".$sitemapIndex->id.".xml");
        }
    // show sitemap
    return $sitemap->render('sitemapindex');
    }

    public function index($id){
        $sitemapLinks = SitemapLink::GetSitemapLinks($id);
        // create sitemap
        $sitemap = \App::make('sitemap');
        foreach ($sitemapLinks as $sitemapLink) {
            $sitemap->add($sitemapLink->url, $sitemapLink->modified , $sitemapLink->priority, $sitemapLink->changefreq);
        }
        // show sitemap
        return $sitemap->render('xml');
    }
}
