<?php

namespace App\Http\Controllers;

use App;
use Illuminate\Http\Request;
use App\Http\Requests\CreateProgramRequest;
use App\Http\Requests\UpdateProgramRequest;
use App\Http\Requests\CreateProgramSeanceRequest;
use App\Http\Requests\UpdateProgramSeanceRequest;
use App\Http\Requests\CreateProgrammingRequest;
use App\Http\Requests\UpdateProgrammingRequest;
use App\Http\Requests\CreatePodcastRequest;
use DB;

use App\Animator;
use App\Program;
use App\ProgramSeance;
use App\Programming;
use App\Podcast;
use App\SitemapIndex;
use App\SitemapLink;

class ProgramController extends Controller
{
    /**
     * Create a new controller instance.
     *
     * @return void
     */
    public function __construct()
    {

    }

    /**
     * programs list
     *
     * @return void
     */
    public function index(){
        $programs=Program::latest("created_at")->with("animators")->paginate(100);
        return view('programs.list')->with(compact('programs'));
    }

    /**
     * new progralm form
     *
     * @return void
     */
    public function newProgram(){
        $animators=Animator::get();
        return view('programs.create')->with(compact("animators"));
    }

    /**
     * create new program ajax request
     *
     * @param Request $request
     * @return void
     */
    public function ajxNewProgram(CreateProgramRequest $request){
        $program=new Program();
        $program->title=$request->get("title");
        $program->meta_title=$request->get("meta_title");
        $program->summary=$request->get("summary");
        $program->content=$request->get("content");
        $program->meta_description=$request->get("meta_description");
        $program->meta_keywords=$request->get("meta_keywords");
        $program->img=$request->get("img");
        $program->img_live=$request->get("img");
        $program->img_alt=$request->get("img_alt");
        $program->status=$request->get("status");
        $program->hashtag=$request->get("hashtag");
        $program->views=0;
        $program->order=Program::count();

        $alias=$request->get("title");
        $alias=str_replace(" ",'-',$alias);
        $alias=str_replace("/",'-',$alias);
        $alias=urlencode($alias);
        $program->url_rewrite=$alias;
        $program->save();

        if(is_array($request->get("animators"))){
            foreach($request->get("animators") as $animatorId){
                $animator=Animator::find($animatorId);
                $program->animators()->attach($animator);
            }
        }

        // add sitemap index
        $sitemapLink = new SitemapLink();
        $url = $sitemapLink->getRoutLink(5).$program->url_rewrite;
        $sitemapLink->InsertSitemapLink(5,$program->id,$url);

        return response()->json(['redirect'=>route('programsList')]);
    }

    /**
     * edit program
     *
     * @param int $programId
     * @return void
     */
    public function edit($programId){
        $program=Program::find($programId);
        $animators=Animator::get();
        return view('programs.edit')->with(compact("program"))->with(compact("animators"));
    }

    /**
     * update program ajax request
     *
     * @param UpdateAnimatorRequest $request
     * @param int $programId
     *
     * @return void
     */
    public function ajxUpdateProgram(UpdateProgramRequest $request,$programId){
        $program=Program::find($programId);

        $program->title=$request->get("title");
        $program->meta_title=$request->get("meta_title");
        $program->summary=$request->get("summary");
        $program->content=$request->get("content");
        $program->meta_description=$request->get("meta_description");
        $program->meta_keywords=$request->get("meta_keywords");
        $program->img=$request->get("img");
        $program->img_live=$request->get("img");
        $program->img_alt=$request->get("img_alt");
        $program->status=$request->get("status");
        $program->hashtag=$request->get("hashtag");

        $program->save();

        $program->animators()->detach();
        if(is_array($request->get("animators"))){
            foreach($request->get("animators") as $animatorId){
                $animator=Animator::find($animatorId);
                $program->animators()->attach($animator);
            }
        }

        // update sitmap link
        $sitemapLink = new SitemapLink();
        $sitemapLink->UpdateSitemapLink(15,$program->id);

        return response()->json(['redirect'=>route('programsList')]);

    }

    /**
     * delete program
     *
     * @param int $programId
     * @return void
     */
    public function delete($programId){
        $program=Program::find($programId);

        $program->animators()->detach();

        // delete sitmap link
        $sitemapLink = new SitemapLink();
        $sitemapLink->DeleteSitemapLink(5, $program->id);
        $podcast= App\Podcast::where("program_id", $programId)->delete();
        $seance= App\ProgramSeance::where("program_id" , $programId)->delete();
        $programming= App\Programming::where("program_id" , $programId)->delete();
        $program->delete();

        return response()->json(['redirect'=>route('programsList')]);
    }

    /**
     * seances list
     *
     * @param int programId
     * @return void
     */
    public function seances($programId){
        $program=Program::find($programId);
        $seances=ProgramSeance::latest("created_at")->whereProgramId($programId)->paginate(100);
        return view('programs.list-seances')->with(compact('program'))->with(compact('seances'));
    }

    /**
     * create seance
     * @param int programId
     * @return void
     */
    public function newProgramSeance($programId){
        $program=Program::find($programId);
        return view('programs.create-seance')->with(compact("program"));
    }

    /**
     * save program seance
     *
     * @param int $programId
     * @return void
     */
    public function ajxNewProgramSeance(CreateProgramSeanceRequest $request,$programId){
        $program=Program::find($programId);
        $seance=new ProgramSeance();
        $seance->program_id=$programId;
        $seance->title=$request->get("title");
        $seance->meta_title=$request->get("meta_title");
        $seance->meta_description=$request->get("meta_description");
        $seance->meta_keywords=$request->get("meta_keywords");
        $seance->order=ProgramSeance::whereProgramId($programId)->count();

        $alias=$request->get("title");


        $alias=str_replace(" ",'-',$alias);
        $alias=str_replace("/",'-',$alias);
        $alias=urlencode($alias);
        $seance->url_rewrite=$alias;


        $seanceCnt=ProgramSeance::where("url_rewrite","REGEXP","{$seance->url_rewrite}(-[0-9]*)?$")->count();
        if($seanceCnt>0){
            $seance->url_rewrite=$seance->url_rewrite."-".($seanceCnt+1);
        }

        $seance->save();

        return response()->json(['redirect'=>route('programSeances',['programId'=>$programId])]);
    }

    /**
     * edit program seance
     *
     * @param int $programId
     * @param int $seanceId
     * @return void
     */
    public function editprogramSeance($programId,$seanceId){
        $seance=ProgramSeance::find($seanceId);
        return view('programs.edit-seance')->with(compact("seance"));
    }

    /**
     * update program seance ajax request
     *
     * @param UpdateProgramSeanceRequest $request
     * @param int $programId
     * @param int $seanceId
     *
     * @return void
     */
    public function ajxUpdateProgramSeance(UpdateProgramSeanceRequest $request,$programId,$seanceId){
        $seance=ProgramSeance::find($seanceId);
        $seance->title=$request->get("title");
        $seance->meta_title=$request->get("meta_title");
        $seance->meta_description=$request->get("meta_description");
        $seance->meta_keywords=$request->get("meta_keywords");
        $seance->save();

        return response()->json(['redirect'=>route('programSeances',['programId'=>$programId])]);
    }

    /**
     * delete program seance
     *
     * @param int $programId
     * @param int $seanceId
     * @return void
     */
    public function deleteProgramSeance($programId,$seanceId){
        $seance=ProgramSeance::find($seanceId);
        $podcast= App\Podcast::where("program_seance_id", $seanceId)->delete();
        $seance->delete();

        return response()->json(['redirect'=>route('programSeances',['programId'=>$programId])]);
    }

    /**
     * programming view
     *
     * @param int $programId
     *
     * @return void
     */
    public function programming($programId){
        $program=Program::find($programId);
        $programmings=Programming::whereProgramId($programId)->oldest("day")->get();
        return view('programs.list-programming')->with(compact("program"))->with(compact("programmings"));
    }

    /**
     * create programming
     * @param int programId
     * @return void
     */
    public function newProgramming($programId){
        $program=Program::find($programId);
        return view('programs.create-programming')->with(compact("program"));
    }

    /**
     * save programming
     *
     * @param CreateProgrammingRequest $request
     * @param int $programId
     *
     * @return void
     */
    public function ajxNewProgramming(CreateProgrammingRequest $request,$programId){
        $program=Program::find($programId);
        $programming=new Programming();
        $programming->program_id=$programId;
        $programming->day=$request->get("day");
        $programming->start_time=$request->get("start_time");
        $programming->end_time=$request->get("end_time");
        $programming->onair=$request->get("onair");

        $programming->save();

        return response()->json(['redirect'=>route('programming',['programId'=>$programId])]);
    }

    /**
     * edit programming page
     * @param int $programId
     * @param int $programmingId
     *
     * @return void
     */
    public function editprogramming($programId,$programmingId){
        $programming=Programming::find($programmingId);
        return view('programs.edit-programming')->with(compact("programming"));
    }

    /**
     * update programming ajax request
     * @param UpdateProgrammingRequest $request
     * @param int $programId
     * @param int $programmingId
     *
     * @return void
     */
    public function ajxUpdateProgramming(UpdateProgrammingRequest $request,$programId,$programmingId){
        $programming=Programming::find($programmingId);
        $programming->program_id=$programId;
        $programming->day=$request->get("day");
        $programming->start_time=$request->get("start_time");
        $programming->end_time=$request->get("end_time");
        $programming->onair=($request->get("onair")) ? $request->get("onair") : 0;

        $programming->save();

        return response()->json(['redirect'=>route('programming',['programId'=>$programId])]);
    }

    /**
     * delete programming
     *
     * @param int $programId
     * @param int $programmingId
     * @return void
     */
    public function deleteProgramming($programId,$programmingId){
        $programming=Programming::find($programmingId);
        $programming->delete();

        return response()->json(['redirect'=>route('programming',['programId'=>$programId])]);
    }
}
