<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Storage;
use Intervention\Image\Facades\Image;
use Carbon\Carbon;

use App\Post;
use App\Tag;
use App\User;
use App\Role;
use App\Category;
use App\SitemapIndex;
use App\SitemapLink;

class PostsMigratorController extends Controller
{

    /**
     * migrator index page
     * 
     * @return void
     */
    public function index(){
        return view('migrator.posts');
    }

    /**
     * migrator get posts
     * 
     * @param Request $request
     * @return void
     */
    public function getPosts(Request $request){
        $defaultCatID = 10; //id from the new database
        $content = Storage::disk('migrator')->get("posts-".$request->get("part").".json");
        $content=str_replace(",[]","",$content);
		$content=str_replace("}][{","},{",$content);
        $content=str_replace("[]","",$content);
        $content=str_replace(",,","",$content);
        $content=str_replace("\'","'",$content);
        $content=str_replace("&bdquo;","bdquo;",$content);
        $content=str_replace("[,","[",$content);
        $content=str_replace("&#39;","'",$content);
		$content=str_replace("�","",$content);
        $content=json_decode($content);
        //var_dump($content);
        //die('log test: '. count($content));
        $finalContent=[];
        foreach($content as $old) {
            $finalContent[] = $old;

            $record = $old;
            $post = new Post();
            $user = User::whereEmail($record->post->bo_user_login)->first();
            $post->user_id = $user->id;
            $post->title = str_replace("bdquo;", '&bdquo;', $record->post->post_title);
            $post->title = str_replace("&#39;", "'", $post->title);
            $post->video_source = 0;
            $post->video_url = '';
            $post->type = 0; //1 = video
            $summary = $record->post->post_summary;
            if (!empty($summary)) {
                $summary = str_replace("bdquo;", '&bdquo;', $summary);
                $summary = str_replace("&#39;", "'", $summary);
                $summary = $this->contentImgUpdateUrl($summary);
                $summary = strip_tags($summary);
            }
            $post->summary = !empty($summary)? $summary : '';
            $body = !empty($record->post->post_content) ? $record->post->post_content : "";
            if (!empty($body)) {
                $body = str_replace("bdquo;", '&bdquo;', $body);
                $body = str_replace("&#39;", "'", $body);
                $body = $this->contentImgUpdateUrl($body);
            }
            //extract video
            $src_video = $this->get_iframe_src($body);
            if(!empty($src_video)){
                $iframe_tag = $src_video['iframe'].'</iframe>';
                $iframe_src = $src_video['src'];
                    //test if from youtube or facebook
                    if (strpos($iframe_src, 'youtube') !== false){
                        $post->video_source = 0;
                        $post->video_url = $iframe_src;
                    }else{
                        $post->video_source = 1;
                        $post->video_url = $iframe_tag;
                    }

                //clean before iframe,will remove \r\n\t
                $pos_iframe = strpos($body, "<iframe");
                $body = substr_replace($body, '', $pos_iframe - 6, 6);
                //remove the iframe from body
                $body = str_replace($iframe_tag, '', $body);
                $post->type = 1; //video
            }

            $post->content = !empty($body)? $body : '';
            $post->meta_title = str_replace("bdquo;",'&bdquo;',$record->post->post_title);
            $post->meta_description = str_replace("bdquo;",'&bdquo;',$record->post->post_summary);
            $post->meta_keywords=$record->post->keywords;
            $post->meta_news_keywords=$record->post->news_keywords;
            //$post_url_rewrite = $record->post->post_url_rewrite;
            //remove encoded quote &#39;
            $post->url_rewrite = $this->arabicSlug($post->title);
            $post->url_rewrite = urlencode($post->url_rewrite);
            $post->img=$record->post->post_img;
            $post->img_alt = (!empty($record->post->cover_img_alt) ? $record->post->cover_img_alt : "");
            $post->status=$record->post->post_status;
            $post->flash_news=0;
            $post->facebook_instant_article=0;
            $post->google_amp=0;
            $post->views=0;
            $post->last_news=0;
            $post->last_news_date=NULL;
            $post->published=Carbon::createFromTimestamp($record->post->post_pdate);
            $post->created_at=Carbon::createFromTimestamp($record->post->post_cdate);
            $post->updated_at=Carbon::createFromTimestamp($record->post->post_udate);
            
            $post->save();


            /*$tags=explode(" ",$record->post->post_tags);
            foreach($tags as $oneTag){
                if($oneTag!="" && $oneTag!=" "){
                    $tag=Tag::find($oneTag);
                    if(!$tag){
                        $tag=new Tag();
                        $tag->title=$oneTag;
                        $tag->url_rewrite=$oneTag;
                        $tag->url_rewrite=str_replace(" ",'-',$tag->url_rewrite);
                        $tag->url_rewrite=urlencode($tag->url_rewrite);
                        $tagCnt=Tag::where("url_rewrite","REGEXP","{$tag->url_rewrite}(-[0-9]*)?$")->count();
                        if($tagCnt>0){
                            $tag->url_rewrite=$tag->url_rewrite."-".$tagCnt;
                        }
                        $tag->save();

                        $sitemapLink = new SitemapLink();
                        $url = $sitemapLink->getRoutLink(4).$tag->url_rewrite;
                        $sitemapLink->InsertSitemapLink(4,$tag->id,$url);
                    }

                    $post->tags()->attach($tag);
                }
            }*/

            foreach($record->categories as $keycat => $cat){
                if(empty($cat)){
                    $category = $defaultCatID;
                }else{
                    $category=Category::whereTitle($cat)->first();
                }
                $post->categories()->attach($category);
                $post->timestamps = false;
                $post->save();
                $post->timestamps = true;
            }


            //sitemap
            $sitemapLink = new SitemapLink();
            $url = $sitemapLink->getRoutLink(1).$post->categories->first()->url_rewrite."/".$post->url_rewrite;
            $sitemapLink->InsertSitemapLink(1,$post->id,$url);

            try{
                $file=file_get_contents("http://old.diwanfm.net/upload/post/".$record->post->post_id."/cover"."/".$post->img);
                Storage::disk("frontoff")->put("photos/posts/".$post->img,$file);

                $image=Image::make($file);
                $image->resize(1200,null,function($constraint){
                    $constraint->aspectRatio();
                });
                $image->crop(1200,628,0,0);
                $image->save("../../diwanfm-frontoff/public/photos/posts/1200x628-".$post->img);

                $image=Image::make($file);
                $image->resize(970,null,function($constraint){
                    $constraint->aspectRatio();
                });
                $image->crop(970,546,0,0);
                $image->save("../../diwanfm-frontoff/public/photos/posts/970x546-".$post->img);

                $image=Image::make($file);
                $image->resize(637,null,function($constraint){
                    $constraint->aspectRatio();
                });
                $image->crop(637,358,0,0);
                $image->save("../../diwanfm-frontoff/public/photos/posts/637x358-".$post->img);

                $image=Image::make($file);
                $image->resize(470,null,function($constraint){
                    $constraint->aspectRatio();
                });
                $image->crop(470,264,0,0);
                $image->save("../../diwanfm-frontoff/public/photos/posts/470x264-".$post->img);

                $image=Image::make($file);
                $image->resize(398,null,function($constraint){
                    $constraint->aspectRatio();
                });
                $image->crop(398,224,0,0);
                $image->save("../../diwanfm-frontoff/public/photos/posts/398x224-".$post->img);

                $image=Image::make($file);
                $image->resize(300,null,function($constraint){
                    $constraint->aspectRatio();
                });
                $image->crop(300,169,0,0);
                $image->save("../../diwanfm-frontoff/public/photos/posts/300x169-".$post->img);

                $image=Image::make($file);
                $image->resize(130,null,function($constraint){
                    $constraint->aspectRatio();
                });
                $image->crop(130,73,0,0);
                $image->save("../../diwanfm-frontoff/public/photos/posts/130x73-".$post->img);

            }catch(\Exception $e){

            }

        }
        return response()->json(['posts'=>$finalContent]);
    }


    public function contentImgUpdateUrl($html){
        $old_path = 'upload/kcf/images';
        $new_path = 'stockage/photos';
        preg_match_all('/<img[^>]+>/i', $html, $images);
        foreach ($images[0] as $image) {
            preg_match('@src="([^"]+)"@', $image, $old_src);
            if (!empty($old_src[1])) {
                $old_src = $old_src[1];
                //remove image if src empty or not under upload/kcf/images
                if (strpos($old_src, $old_path) === false) {
                    $html = str_replace($image, '', $html);
                } else {
                    $old_url_upload = $old_src;
                    if (strpos($old_src, 'http://old.diwanfm.net') === false) {
                        $old_url_upload = 'http://old.diwanfm.net' . $old_src;
                    }
                    $file = file_get_contents($old_url_upload);
                    $URLparts = parse_url($old_url_upload);
                    $file_old = pathinfo($URLparts['path']);
                    $fileName = $file_old['filename'] . '.' . $file_old['extension'];
                    $this->contentImgUpload($file, $new_path . '/' . $fileName);

                    $new_src = str_replace($old_path, $new_path, $old_src);
                    $new_src = str_replace('http://old.diwanfm.net', '', $new_src);
                    $html = str_replace($old_src, $new_src, $html);
                }
            }
        }


        return $html;
    }

    /*
     * upload images from old site
     */
    public function contentImgUpload($file, $path){
        try{
        Storage::disk("frontoff")->put($path,$file);
        }catch (\Exception $e){
            print_r($e->getMessage());
        }
    }

    public function arabicSlug($string, $separator = '-'){
        if (is_null($string)) {
            return "";
        }

        // Remove spaces from the beginning and from the end of the string
        $string = trim($string);

        // Lower case everything
        // using mb_strtolower() function is important for non-Latin UTF-8 string | more info: http://goo.gl/QL2tzK
        $string = mb_strtolower($string, "UTF-8");;

        // Make alphanumeric (removes all other characters)
        // this makes the string safe especially when used as a part of a URL
        // this keeps latin characters and arabic charactrs as well
        $string = preg_replace("/[^a-z0-9_\s-ءاأإآؤئبتثجحخدذرزسشصضطظعغفقكلمنهويةى]#u/", "", $string);

        // Remove multiple dashes or whitespaces
        $string = preg_replace("/[\s-]+/", " ", $string);

        // Convert whitespaces and underscore to the given separator
        $string = preg_replace("/[\s_]/", $separator, $string);

        return $string;
    }


        /**
         * Grab all iframe src from a string
         */
        public function get_iframe_src( $input) {
        preg_match_all("/<iframe[^>]*src=[\"|']([^'\"]+)[\"|'][^>]*>/i", $input, $output );
        $return = array();
        if( isset( $output[1][0] ) ) {
            $return['src'] = $output[1][0];
        }
        if( isset( $output[0][0] ) ) {
            $return['iframe'] = $output[0][0];
        }
        return $return;
    }

}
