<?php

namespace App\Http\Controllers;

use App\TagsPredefinis;
use Illuminate\Http\Request;
use App\Http\Requests\CreateArticleRequest;
use App\Http\Requests\UpdateArticleRequest;
use App\Http\Requests\CreateVideoRequest;
use App\Http\Requests\UpdateVideoRequest;
use App\Http\Requests\CreateGalleryRequest;
use App\Http\Requests\UpdateGalleryRequest;
use App\Http\Requests\SearchPostRequest;
use App\User;
use App\Post;
use App\PostPhoto;
use App\Category;
use App\PostViews;
use App\Tag;
use App\Device;
use App\Utilisateur;
use Carbon\Carbon;
use App\SitemapIndex;
use App\SitemapLink;
use App\Token;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\File;
use Illuminate\Support\Facades\Log;
use PhpParser\Parser\Tokens;
use CommonMark\Node\Item;
class PostController extends Controller
{
    /**
     * Create a new controller instance.
     *
     * @return void
     */
    public function __construct()
    {

    }

    /**
     * list articles
     * @return void
     */
    public function index(){

        $posts=Post::whereType(0)->latest("created_at")->with(["tags","user","categories"])->paginate(100);

    	return view('posts.list-articles',compact('posts'));
    }

    /**
     * list videos
     * @return void
     */
    public function listVideo(){
        $posts=Post::whereType(1)->latest("created_at")->with(["tags","user","categories"])->paginate(100);
        return view('posts.list-videos',compact('posts'));
    }

    /**
     * list gallery
     * @return void
     */
    public function listGallery(){
        $posts=Post::whereType(2)->latest("created_at")->with(["tags","user","categories"])->paginate(100);
        return view('posts.list-gallery',compact('posts'));
    }


    /**
     * new article form
     *
     * @return void
     */
    public function newArticle(){
        $categories=Category::where('isActive', 1)->get();
        $tagsPredefinis=TagsPredefinis::get();
        $users=User::whereStatus(1)->get();
        return view('posts.create-article')
        ->with(compact('categories'))
        ->with(compact("users"))
        ->with(compact("tagsPredefinis"));
    }

    /**
     * new article video
     *
     * @return void
     */
    public function newVideo(){
        $categories=Category::where('isActive', 1)->get();
        $tagsPredefinis=TagsPredefinis::get();
        $users=User::whereStatus(1)->get();
        return view('posts.create-video')
        ->with(compact('categories'))
        ->with(compact("users"))
        ->with(compact("tagsPredefinis"));
    }

    /**
     * new article gallery
     *
     * @return void
     */
    public function newGallery(){
        $categories=Category::where('isActive', 1)->get();
        $tagsPredefinis=TagsPredefinis::get();
        $users=User::whereStatus(1)->get();
        return view('posts.create-gallery')
        ->with(compact('categories'))
        ->with(compact("users"))
        ->with(compact("tagsPredefinis"));
    }

    // firebase push notification function(service that injected by controller to notify user )
    public  function androidPush($ids,$message,$data)
    {

        $url = 'https://fcm.googleapis.com/fcm/send';
        $key= 'AAAA_G8OLDI:APA91bGSsrH7c4wwA4TtcQDIdntxutU84R_hvsoBZGNubNl0J89QG1JfW5mo9UWMYv3g3zGMfe9Kzvs_jzhQNiYLn70w3vD8sZ2SjV06B39DTkSPskUv732hE7z-NLYtffs8geivQXnT';

        //$devices[] = $this->em->getRepository(Device::class)->findBy(array("user" => $ids));
        $devices=[];
        $tokens=[];
        //= Utilisateur::find($ids);
        foreach ($ids as $id){
            $tokenList = Token::where('utilisateur_id', $id)->get();
            foreach($tokenList as $token){
                array_push($tokens,$token->tokenFcm);
            }
        }

        $headers = array(
            'Authorization: key=' . $key,
            'Content-Type: application/json'
        );
        $fields = array(
            'registration_ids' => $tokens,
            'notification' => $message,
            //'type_a' => $type_a,
            'data' =>$data
        );

        $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL, $url);
        curl_setopt($ch, CURLOPT_POST, true);
        curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
        curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, 0);
        curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, 0);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($fields));
        $result = curl_exec($ch);
        if (curl_errno($ch)) {
            echo 'Curl error: ' . curl_error($ch);
        }
        curl_close($ch);

        return $result;

    }

    public function ajxNewArticle(CreateArticleRequest $request){


        $post=new post();
        $post->rss_title=$request->get("rss_title");
        $post->title=$request->get("title");
        $post->summary=$request->get("summary");
        $post->content=$request->get("content");
        $post->display_user_id=$request->get("display_user_id");
        $post->meta_title=$request->get("meta_title");
        $post->meta_description=$request->get("meta_description");
        $post->meta_description=$request->get("meta_description");
        $post->meta_keywords=$request->get("meta_keywords");
        $post->lang=$request->get("lang");
        $post->meta_news_keywords=$request->get("meta_news_keywords");
        $post->flash_news=($request->get("flash_news")) ? 1 : 0;
        $post->facebook_instant_article=($request->get("facebook_instant_article"))? 1 : 0;
        $post->is_restricted=($request->get("private_post"))? 1 : 0;
        $post->google_amp=($request->get("google_amp"))? 1 : 0;
        $post->img=$request->get("img");
        $post->img_alt=$request->get("img_alt");
        $post->title_flash=($request->get("title_flash"))? $request->get("title_flash") : "";

        $post->url_rewrite=$request->get("title");
        $post->url_rewrite=str_replace(" ",'-',$post->url_rewrite);
        $post->url_rewrite=urlencode($post->url_rewrite);
        $postCnt=Post::where("url_rewrite","REGEXP","{$post->url_rewrite}(-[0-9]*)?$")->count();
        if($postCnt>0){
            $post->url_rewrite=$post->url_rewrite."-".$postCnt;
        }

        $user = \Auth::user();
        $post->user_id=$user->id;
        $post->type=0;
        $post->video_url="";
        $post->video_source=0;
        $post->views=0;
        if($user->hasRole("Admin") || $user->hasRole("Webmaster") || $user->hasRole("JournalisteWeb")){
            $post->status=$request->get('status');
            if($post->status==2){
                $post->published=Carbon::now();
            }
        }else{
            $post->status=0;
        }

        $post->last_news=($request->get("last_news"))? 1 : 0;
        if($post->last_news){
            $post->last_news_date=Carbon::now();
        }

        $post->save();
     if(is_array($request->get("category"))){
            foreach($request->get("category") as $categoryId){
                $cat=Category::find($categoryId);
                $post->categories()->attach($cat);
            }
        }

        if(is_array($request->get("tags"))){
            foreach($request->get("tags") as $tagId){
                $tag=Tag::where('id', $tagId)->first();
		        if(!$tag){
                    $tag=Tag::where('title', $tagId)->first();
                }
                if(!$tag){
                    $tag=new Tag();
                    $tag->title=$tagId;
                    $tag->url_rewrite=$tagId;
                    $tag->url_rewrite=str_replace(" ",'-',$tag->url_rewrite);
                    $tag->url_rewrite=urlencode($tag->url_rewrite);
                    $tagCnt=Tag::where("url_rewrite","REGEXP","{$tag->url_rewrite}(-[0-9]*)?$")->count();
                    if($tagCnt>0){
                        $tag->url_rewrite=$tag->url_rewrite."-".$tagCnt;
                    }
                    $tag->save();

                    // add sitemap index
                    $sitemapLink = new SitemapLink();
                    $url = $sitemapLink->getRoutLink(4).$tag->url_rewrite;
                    $sitemapLink->InsertSitemapLink(4,$tag->id,$url);
                }
                $post->tags()->attach($tag);
            }
        }

        $old_path = env('PHOTOS_URL_FRONT').'posts/';
        $postYear = date("Y", strtotime($post->created_at));
        $postMonth = date("m", strtotime($post->created_at));
        $postDay = date("d", strtotime($post->created_at));
        $path = env('PHOTOS_URL_FRONT'). '/posts/'. $postYear.'/'.$postMonth.'/'.$postDay;
        File::makeDirectory($path, $mode = 0777, true, true);
        if(File::exists($old_path.$post->img)){
            File::move($old_path.$post->img, $path.'/'.$post->img);
            File::move($old_path.'130x73-'.$post->img, $path.'/130x73-'.$post->img);
            File::move($old_path.'300x169-'.$post->img, $path.'/300x169-'.$post->img);
            File::move($old_path.'398x224-'.$post->img, $path.'/398x224-'.$post->img);
            File::move($old_path.'470x264-'.$post->img, $path.'/470x264-'.$post->img);
            File::move($old_path.'637x358-'.$post->img, $path.'/637x358-'.$post->img);
            File::move($old_path.'970x546-'.$post->img, $path.'/970x546-'.$post->img);
            File::move($old_path.'1200x628-'.$post->img, $path.'/1200x628-'.$post->img);
        }

/************************************************************************************************************************* */
        if($post->status==2){

            $categories =[];
                if(is_array($request->get("category"))){
                    foreach($request->get("category") as $categoryId){
                        $cat=Category::find($categoryId);
                        array_push($categories,$cat);
                        $post->categories()->attach($cat);
                    }
                }
        $listUsers = [];
            foreach($categories as $categ)
            {
                $users = DB::table('category_utilisateur')->where('category_id', $categ->id)->get();
                foreach($users as $user){
                    array_push($listUsers, $user->utilisateur_id);
                }
            }
        $listUsers = array_unique($listUsers);
            $message=[];
            $message['title']=$post->title;
            $message['body']=$post->content;
            $data['image']='http://diwanfm.net/photos/posts/'. $postYear.'/'.$postMonth.'/'.$postDay.'/'.$post->img;
            //$data=[];

            // $res = $this->androidPush($listUsers,$message,$data);

        }
/************************************************************************************************************************ */

        // add sitemap index
        $sitemapLink = new SitemapLink();
        $url = $sitemapLink->getRoutLink(1).$post->categories->first()->url_rewrite."/".$post->url_rewrite;
        $sitemapLink->InsertSitemapLink(1,$post->id,$url);

        return response()->json(['redirect'=>route('postsList')]);
    }

    public function ajxNewVideo(CreateVideoRequest $request){

        $post=new post();
        $post->title=$request->get("title");

        $post->summary=$request->get("summary");
        $post->content=$request->get("content");
        $post->display_user_id=$request->get("display_user_id");

        $post->video_url=($request->get('youtube_url')) ? $request->get('youtube_url') : $request->get('facebook_embed');
        $post->video_source=($request->youtube_url) ? 0 : 1;

        $post->is_restricted=($request->get("private_post"))? 1 : 0;
        $post->meta_title=$request->get("meta_title");
        $post->title_flash=($request->get("title_flash"))? $request->get("title_flash") : "";
        $post->meta_description=$request->get("meta_description");

        $post->meta_keywords=$request->get("meta_keywords");
        $post->meta_news_keywords=$request->get("meta_news_keywords");
        $post->flash_news=($request->get("flash_news")) ? 1 : 0;

        $post->facebook_instant_article=($request->get("facebook_instant_article"))? 1 : 0;


        $post->google_amp=($request->get("google_amp"))? 1 : 0;
        $post->img=$request->get("img");
        $post->img_alt=$request->get("img_alt");

        $post->url_rewrite=$request->get("title");
        $post->url_rewrite=str_replace(" ",'-',$post->url_rewrite);
        $post->url_rewrite=urlencode($post->url_rewrite);
        $postCnt=Post::where("url_rewrite","REGEXP","{$post->url_rewrite}(-[0-9]*)?$")->count();
        if($postCnt>0){
            $post->url_rewrite=$post->url_rewrite."-".$postCnt;
        }

        $user = \Auth::user();
        $post->user_id=$user->id;
        $post->type=1;
        $post->views=0;
        if($user->hasRole("Admin") || $user->hasRole("Webmaster") || $user->hasRole("JournalisteWeb")){
            $post->status=$request->get('status');
            if($post->status==2){
                $post->published=Carbon::now();
            }
        }else{
            $post->status=0;
        }

        $post->save();

        if(is_array($request->get("category"))){
            foreach($request->get("category") as $categoryId){
                $cat=Category::find($categoryId);
                $post->categories()->attach($cat);
            }
        }

        if(is_array($request->get("tags"))){
            foreach($request->get("tags") as $tagId){
                $tag=Tag::where('id', $tagId)->first();
		        if(!$tag){
                    $tag=Tag::where('title', $tagId)->first();
                }
                if(!$tag){
                    $tag=new Tag();
                    $tag->title=$tagId;
                    $tag->url_rewrite=$tagId;
                    $tag->url_rewrite=str_replace(" ",'-',$tag->url_rewrite);
                    $tag->url_rewrite=urlencode($tag->url_rewrite);
                    $tagCnt=Tag::where("url_rewrite","REGEXP","{$tag->url_rewrite}(-[0-9]*)?$")->count();
                    if($tagCnt>0){
                        $tag->url_rewrite=$tag->url_rewrite."-".$tagCnt;
                    }
                    $tag->save();

                    // add sitemap index
                    $sitemapLink = new SitemapLink();
                    $url = $sitemapLink->getRoutLink(4).$tag->url_rewrite;
                    $sitemapLink->InsertSitemapLink(4,$tag->id,$url);
                }
                $post->tags()->attach($tag);
            }
        }

        $old_path = env('PHOTOS_URL_FRONT').'posts/';
        $postYear = date("Y", strtotime($post->created_at));
        $postMonth = date("m", strtotime($post->created_at));
        $postDay = date("d", strtotime($post->created_at));
        $path = env('PHOTOS_URL_FRONT'). '/posts/'. $postYear.'/'.$postMonth.'/'.$postDay;
        File::makeDirectory($path, $mode = 0777, true, true);
        if(File::exists($old_path.$post->img)){
            File::move($old_path.$post->img, $path.'/'.$post->img);
            File::move($old_path.'130x73-'.$post->img, $path.'/130x73-'.$post->img);
            File::move($old_path.'300x169-'.$post->img, $path.'/300x169-'.$post->img);
            File::move($old_path.'398x224-'.$post->img, $path.'/398x224-'.$post->img);
            File::move($old_path.'470x264-'.$post->img, $path.'/470x264-'.$post->img);
            File::move($old_path.'637x358-'.$post->img, $path.'/637x358-'.$post->img);
            File::move($old_path.'970x546-'.$post->img, $path.'/970x546-'.$post->img);
            File::move($old_path.'1200x628-'.$post->img, $path.'/1200x628-'.$post->img);
        }
        // add sitemap index
        $sitemapLink = new SitemapLink();
        $url = $sitemapLink->getRoutLink(1).$post->categories->first()->url_rewrite."/".$post->url_rewrite;
        $sitemapLink->InsertSitemapLink(1,$post->id,$url);

        return response()->json(['redirect'=>route('VideosList')]);
    }

    public function ajxNewGallery(CreateGalleryRequest $request){

        $post=new post();
        $post->title=$request->get("title");

        $post->summary=$request->get("summary");
        $post->content=$request->get("content");
        $post->display_user_id=$request->get("display_user_id");

        $post->video_url="";
        $post->video_source=0;

        $post->meta_title=$request->get("meta_title");
        $post->title_flash=($request->get("title_flash"))? $request->get("title_flash") : "";
        $post->meta_description=$request->get("meta_description");

        $post->meta_keywords=$request->get("meta_keywords");
        $post->meta_news_keywords=$request->get("meta_news_keywords");
        $post->flash_news=($request->get("flash_news")) ? 1 : 0;

        $post->facebook_instant_article=($request->get("facebook_instant_article"))? 1 : 0;
        $post->is_restricted=($request->get("private_post"))? 1 : 0;

        $post->google_amp=($request->get("google_amp"))? 1 : 0;
        $post->img=$request->get("img");
        $post->img_alt=$request->get("img_alt");

        $post->url_rewrite=$request->get("title");
        $post->url_rewrite=str_replace(" ",'-',$post->url_rewrite);
        $post->url_rewrite=urlencode($post->url_rewrite);
        $postCnt=Post::where("url_rewrite","REGEXP","{$post->url_rewrite}(-[0-9]*)?$")->count();
        if($postCnt>0){
            $post->url_rewrite=$post->url_rewrite."-".$postCnt;
        }

        $user = \Auth::user();
        $post->user_id=$user->id;
        $post->type=2;
        $post->views=0;
        if($user->hasRole("Admin") || $user->hasRole("Webmaster") || $user->hasRole("JournalisteWeb")){
            $post->status=$request->get('status');
            if($post->status==2){
                $post->published=Carbon::now();
            }
        }else{
            $post->status=0;
        }

        $post->save();

        if(is_array($request->get("category"))){
            foreach($request->get("category") as $categoryId){
                $cat=Category::find($categoryId);
                $post->categories()->attach($cat);
            }
        }



        if(is_array($request->get("tags"))){
            foreach($request->get("tags") as $tagId){
                $tag=Tag::where('id', $tagId)->first();
		        if(!$tag){
                    $tag=Tag::where('title', $tagId)->first();
                }
                if(!$tag){
                    $tag=new Tag();
                    $tag->title=$tagId;
                    $tag->url_rewrite=$tagId;
                    $tag->url_rewrite=str_replace(" ",'-',$tag->url_rewrite);
                    $tag->url_rewrite=urlencode($tag->url_rewrite);
                    $tagCnt=Tag::where("url_rewrite","REGEXP","{$tag->url_rewrite}(-[0-9]*)?$")->count();
                    if($tagCnt>0){
                        $tag->url_rewrite=$tag->url_rewrite."-".$tagCnt;
                    }
                    $tag->save();

                    // add sitemap index
                    $sitemapLink = new SitemapLink();
                    $url = $sitemapLink->getRoutLink(4).$tag->url_rewrite;
                    $sitemapLink->InsertSitemapLink(4,$tag->id,$url);
                }
                $post->tags()->attach($tag);
            }
        }

        $old_path = env('PHOTOS_URL_FRONT').'posts/';
        $postYear = date("Y", strtotime($post->created_at));
        $postMonth = date("m", strtotime($post->created_at));
        $postDay = date("d", strtotime($post->created_at));
        $path = env('PHOTOS_URL_FRONT'). '/posts/'. $postYear.'/'.$postMonth.'/'.$postDay;
        File::makeDirectory($path, $mode = 0777, true, true);
        if(File::exists($old_path.$post->img)){
            File::move($old_path.$post->img, $path.'/'.$post->img);
            File::move($old_path.'130x73-'.$post->img, $path.'/130x73-'.$post->img);
            File::move($old_path.'300x169-'.$post->img, $path.'/300x169-'.$post->img);
            File::move($old_path.'398x224-'.$post->img, $path.'/398x224-'.$post->img);
            File::move($old_path.'470x264-'.$post->img, $path.'/470x264-'.$post->img);
            File::move($old_path.'637x358-'.$post->img, $path.'/637x358-'.$post->img);
            File::move($old_path.'970x546-'.$post->img, $path.'/970x546-'.$post->img);
            File::move($old_path.'1200x628-'.$post->img, $path.'/1200x628-'.$post->img);
        }

        for($i=1;$i<=10;$i++){
            if($request->get("img".$i)){
                $gImg=new PostPhoto();
                $gImg->photo=$request->get("img".$i);
                $gImg->post_id=$post->id;
                $gImg->save();

                File::makeDirectory($path, $mode = 0777, true, true);
                if(File::exists($old_path.$gImg->photo)){
                    File::move($old_path.$gImg->photo, $path.'/'.$gImg->photo);
                    File::move($old_path.'130x73-'.$gImg->photo, $path.'/130x73-'.$gImg->photo);
                    File::move($old_path.'300x169-'.$gImg->photo, $path.'/300x169-'.$gImg->photo);
                    File::move($old_path.'398x224-'.$gImg->photo, $path.'/398x224-'.$gImg->photo);
                    File::move($old_path.'470x264-'.$gImg->photo, $path.'/470x264-'.$gImg->photo);
                    File::move($old_path.'637x358-'.$gImg->photo, $path.'/637x358-'.$gImg->photo);
                    File::move($old_path.'970x546-'.$gImg->photo, $path.'/970x546-'.$gImg->photo);
                    File::move($old_path.'1200x628-'.$gImg->photo, $path.'/1200x628-'.$gImg->photo);
                }
            }
        }

        // add sitemap index
        $sitemapLink = new SitemapLink();
        $url = $sitemapLink->getRoutLink(8).$post->categories->first()->url_rewrite."/".$post->url_rewrite;
        $sitemapLink->InsertSitemapLink(8,$post->id,$url);

        return response()->json(['redirect'=>route('galleryList')]);
    }


     /**
     * edit article form
     *
     * @param int $postId
     * @return void
     */
    public function editArticle($postId){
        $post=Post::find($postId);
        $categories=Category::where('isActive', 1)->get();
        $tagsPredefinis=TagsPredefinis::get();
        return view('posts.edit-article')
        ->with(compact('categories'))
        ->with(compact("post"))
        ->with(compact("tagsPredefinis"));
    }

    /**
     * edit video form
     *
     * @param int $postId
     * @return void
     */
    public function editVideo($videoId){
        $post=Post::find($videoId);
        $categories=Category::where('isActive', 1)->get();
        $tagsPredefinis=TagsPredefinis::get();
        return view('posts.edit-video')
        ->with(compact('categories'))
        ->with(compact("post"))
        ->with(compact("tagsPredefinis"));
    }

    /**
     * edit gallery form
     *
     * @param int $postId
     * @return void
     */
    public function editGallery($galleryId){
        $post=Post::find($galleryId);
        $categories=Category::where('isActive', 1)->get();
        $tagsPredefinis=TagsPredefinis::get();
        return view('posts.edit-gallery')
        ->with(compact('categories'))
        ->with(compact("post"))
        ->with(compact("tagsPredefinis"));
    }

    /**
     * update article
     *
     * @param UpdateArticleRequest $request
     * @param int $postId
     * @return void
     */
    public function ajxUpdateArticle(UpdateArticleRequest $request,$postId){
        $post=Post::find($postId);
        $user = \Auth::user();
        if(!($user->hasRole("Admin") || $user->hasRole("Webmaster") || $user->hasRole("JournalisteWeb")) && $post->status==2){
            abort(403, 'Access denied');
        }
        $post->rss_title=$request->get("rss_title");
        $post->title=$request->get("title");
        $post->summary=$request->get("summary");
        $post->content=$request->get("content");
        $post->meta_title=$request->get("meta_title");
        $post->meta_description=$request->get("meta_description");
        $post->meta_description=$request->get("meta_description");
        $post->meta_keywords=$request->get("meta_keywords");
        $post->lang=$request->get("lang");
        $post->meta_news_keywords=$request->get("meta_news_keywords");
        $post->flash_news=($request->get("flash_news")) ? 1 : 0;
        $post->facebook_instant_article=($request->get("facebook_instant_article"))? 1 : 0;
        $post->is_restricted=($request->get("private_post"))? 1 : 0;
        $post->google_amp=($request->get("google_amp"))? 1 : 0;
        $post->img=$request->get("img");
        $post->img_alt=$request->get("img_alt");
        $post->title_flash=($request->get("title_flash"))? $request->get("title_flash") : "";

        if($post->status==2){
            if($user->hasRole("Admin")){
                $post->status=$request->get('status');
            }
        }else{

            if($request->get('status')=="2"){
                if($user->hasRole("Admin") || $user->hasRole("JournalisteWeb")){
                    $post->status=$request->get('status');
                    $post->published=Carbon::now();
                }
            }else{
                $post->status=$request->get('status');
            }
        }

        if(!$post->last_news && $request->get("last_news")){
            $post->last_news_date=Carbon::now();
        }
        $post->last_news=($request->get("last_news"))? 1 : 0;

        $post->save();

        $post->categories()->detach();
        if(is_array($request->get("category"))){
            foreach($request->get("category") as $categoryId){
                $cat=Category::find($categoryId);
                $post->categories()->attach($cat);
            }
        }

        $post->tags()->detach();
        if(is_array($request->get("tags"))){
            foreach($request->get("tags") as $tagId){
                $tag=Tag::where('id', $tagId)->first();
		        if(!$tag){
                    $tag=Tag::where('title', $tagId)->first();
                }
                if(!$tag){
                    $tag=new Tag();
                    $tag->title=$tagId;
                    $tag->url_rewrite=$tagId;
                    $tag->url_rewrite=str_replace(" ",'-',$tag->url_rewrite);
                    $tag->url_rewrite=urlencode($tag->url_rewrite);
                    $tagCnt=Tag::where("url_rewrite","REGEXP","{$tag->url_rewrite}(-[0-9]*)?$")->count();
                    if($tagCnt>0){
                        $tag->url_rewrite=$tag->url_rewrite."-".$tagCnt;
                    }
                    $tag->save();

                    // add sitemap index
                    $sitemapLink = new SitemapLink();
                    $url = $sitemapLink->getRoutLink(4).$tag->url_rewrite;
                    $sitemapLink->InsertSitemapLink(4,$tag->id,$url);
                }
                $post->tags()->attach($tag);
            }
        }

        $old_path = env('PHOTOS_URL_FRONT').'posts/';
        $postYear = date("Y", strtotime($post->created_at));
        $postMonth = date("m", strtotime($post->created_at));
        $postDay = date("d", strtotime($post->created_at));
        $path = env('PHOTOS_URL_FRONT'). '/posts/'. $postYear.'/'.$postMonth.'/'.$postDay;

        if(File::exists($old_path.$post->img)){
            File::makeDirectory($path, $mode = 0777, true, true);
            File::move($old_path.$post->img, $path.'/'.$post->img);
            File::move($old_path.'130x73-'.$post->img, $path.'/130x73-'.$post->img);
            File::move($old_path.'300x169-'.$post->img, $path.'/300x169-'.$post->img);
            File::move($old_path.'398x224-'.$post->img, $path.'/398x224-'.$post->img);
            File::move($old_path.'470x264-'.$post->img, $path.'/470x264-'.$post->img);
            File::move($old_path.'637x358-'.$post->img, $path.'/637x358-'.$post->img);
            File::move($old_path.'970x546-'.$post->img, $path.'/970x546-'.$post->img);
            File::move($old_path.'1200x628-'.$post->img, $path.'/1200x628-'.$post->img);
        }

        // update sitmap link
        $sitemapLink = new SitemapLink();
        $sitemapLink->UpdateSitemapLink(1,$post->id);

        return response()->json(['redirect'=>route('postsList')]);
    }

    /**
     * update video
     *
     * @param UpdateVideoRequest $request
     * @param int $postId
     * @return void
     */
    public function ajxUpdateVideo(UpdateVideoRequest $request,$postId){
        $post=Post::find($postId);
        $user = \Auth::user();
        if(!($user->hasRole("Admin") || $user->hasRole("Webmaster") || $user->hasRole("JournalisteWeb")) && $post->status==2){
            abort(403, 'Access denied');
        }

        $post->title=$request->get("title");
        $post->summary=$request->get("summary");
        $post->content=$request->get("content");

        $post->video_url=($request->get('youtube_url')) ? $request->get('youtube_url') : $request->get('facebook_embed');
        $post->video_source=($request->youtube_url) ? 0 : 1;
        $post->is_restricted=($request->get("private_post"))? 1 : 0;
        $post->meta_title=$request->get("meta_title");
        $post->meta_description=$request->get("meta_description");
        $post->meta_description=$request->get("meta_description");
        $post->meta_keywords=$request->get("meta_keywords");
        $post->meta_news_keywords=$request->get("meta_news_keywords");
        $post->flash_news=($request->get("flash_news")) ? 1 : 0;
        $post->facebook_instant_article=($request->get("facebook_instant_article"))? 1 : 0;
        $post->google_amp=($request->get("google_amp"))? 1 : 0;
        $post->img=$request->get("img");
        $post->img_alt=$request->get("img_alt");
        $post->title_flash=($request->get("title_flash"))? $request->get("title_flash") : "";

        if($post->status==2){
            if(($user->hasRole("Admin") || $user->hasRole("JournalisteWeb")) && $request->get('status')!=null){
                $post->status=$request->get('status');
            }
        }else{

            if($request->get('status')=="2"){
                if($user->hasRole("Admin") || $user->hasRole("JournalisteWeb")){
                    $post->status=$request->get('status');
                    $post->published=Carbon::now();
                }
            }else{
                $post->status=$request->get('status');
            }
        }

        $post->save();

        $post->categories()->detach();
        if(is_array($request->get("category"))){
            foreach($request->get("category") as $categoryId){
                $cat=Category::find($categoryId);
                $post->categories()->attach($cat);
            }
        }

        $post->tags()->detach();
        if(is_array($request->get("tags"))){
            foreach($request->get("tags") as $tagId){
                $tag=Tag::where('id', $tagId)->first();
		        if(!$tag){
                    $tag=Tag::where('title', $tagId)->first();
                }
                if(!$tag){
                    $tag=new Tag();
                    $tag->title=$tagId;
                    $tag->url_rewrite=$tagId;
                    $tag->url_rewrite=str_replace(" ",'-',$tag->url_rewrite);
                    $tag->url_rewrite=urlencode($tag->url_rewrite);
                    $tagCnt=Tag::where("url_rewrite","REGEXP","{$tag->url_rewrite}(-[0-9]*)?$")->count();
                    if($tagCnt>0){
                        $tag->url_rewrite=$tag->url_rewrite."-".$tagCnt;
                    }
                    $tag->save();

                    // add sitemap index
                    $sitemapLink = new SitemapLink();
                    $url = $sitemapLink->getRoutLink(4).$tag->url_rewrite;
                    $sitemapLink->InsertSitemapLink(4,$tag->id,$url);
                }
                $post->tags()->attach($tag);
            }
        }

        $old_path = env('PHOTOS_URL_FRONT').'posts/';
        $postYear = date("Y", strtotime($post->created_at));
        $postMonth = date("m", strtotime($post->created_at));
        $postDay = date("d", strtotime($post->created_at));
        $path = env('PHOTOS_URL_FRONT'). '/posts/'. $postYear.'/'.$postMonth.'/'.$postDay;

        if(File::exists($old_path.$post->img)){
            File::makeDirectory($path, $mode = 0777, true, true);
            File::move($old_path.$post->img, $path.'/'.$post->img);
            File::move($old_path.'130x73-'.$post->img, $path.'/130x73-'.$post->img);
            File::move($old_path.'300x169-'.$post->img, $path.'/300x169-'.$post->img);
            File::move($old_path.'398x224-'.$post->img, $path.'/398x224-'.$post->img);
            File::move($old_path.'470x264-'.$post->img, $path.'/470x264-'.$post->img);
            File::move($old_path.'637x358-'.$post->img, $path.'/637x358-'.$post->img);
            File::move($old_path.'970x546-'.$post->img, $path.'/970x546-'.$post->img);
            File::move($old_path.'1200x628-'.$post->img, $path.'/1200x628-'.$post->img);
        }

        // update sitmap link
        $sitemapLink = new SitemapLink();
        $sitemapLink->UpdateSitemapLink(1,$post->id);

        return response()->json(['redirect'=>route('VideosList')]);
    }

    /**
     * update gallery
     *
     * @param UpdateGalleryRequest $request
     * @param int $postId
     * @return void
     */
    public function ajxUpdateGallery(UpdateGalleryRequest $request,$postId){
        $post=Post::find($postId);
        $user = \Auth::user();
        if(!($user->hasRole("Admin") || $user->hasRole("Webmaster") || $user->hasRole("JournalisteWeb")) && $post->status==2){
            abort(403, 'Access denied');
        }

        $post->title=$request->get("title");
        $post->summary=$request->get("summary");
        $post->content=$request->get("content");

        $post->meta_title=$request->get("meta_title");
        $post->meta_description=$request->get("meta_description");
        $post->meta_description=$request->get("meta_description");
        $post->meta_keywords=$request->get("meta_keywords");
        $post->meta_news_keywords=$request->get("meta_news_keywords");
        $post->flash_news=($request->get("flash_news")) ? 1 : 0;
        $post->facebook_instant_article=($request->get("facebook_instant_article"))? 1 : 0;
        $post->is_restricted=($request->get("private_post"))? 1 : 0;
        $post->google_amp=($request->get("google_amp"))? 1 : 0;
        $post->img=$request->get("img");
        $post->img_alt=$request->get("img_alt");
        $post->title_flash=($request->get("title_flash"))? $request->get("title_flash") : "";

        if($post->status==2){
            if($user->hasRole("Admin")){
                $post->status=$request->get('status');
            }
        }else{

            if($request->get('status')=="2"){
                if($user->hasRole("Admin") || $user->hasRole("JournalisteWeb")){
                    $post->status=$request->get('status');
                    $post->published=Carbon::now();
                }
            }else{
                $post->status=$request->get('status');
            }
        }

        $post->save();

        $post->categories()->detach();
        if(is_array($request->get("category"))){
            foreach($request->get("category") as $categoryId){
                $cat=Category::find($categoryId);
                $post->categories()->attach($cat);
            }
        }

        $post->tags()->detach();
        if(is_array($request->get("tags"))){
            foreach($request->get("tags") as $tagId){
                $tag=Tag::where('id', $tagId)->first();
		        if(!$tag){
                    $tag=Tag::where('title', $tagId)->first();
                }
                if(!$tag){
                    $tag=new Tag();
                    $tag->title=$tagId;
                    $tag->url_rewrite=$tagId;
                    $tag->url_rewrite=str_replace(" ",'-',$tag->url_rewrite);
                    $tag->url_rewrite=urlencode($tag->url_rewrite);
                    $tagCnt=Tag::where("url_rewrite","REGEXP","{$tag->url_rewrite}(-[0-9]*)?$")->count();
                    if($tagCnt>0){
                        $tag->url_rewrite=$tag->url_rewrite."-".$tagCnt;
                    }
                    $tag->save();

                    // add sitemap index
                    $sitemapLink = new SitemapLink();
                    $url = $sitemapLink->getRoutLink(4).$tag->url_rewrite;
                    $sitemapLink->InsertSitemapLink(4,$tag->id,$url);
                }
                $post->tags()->attach($tag);
            }
        }

        foreach($post->photos as $photo){
            $photo->delete();
        }

        $old_path = env('PHOTOS_URL_FRONT').'posts/';
        $postYear = date("Y", strtotime($post->created_at));
        $postMonth = date("m", strtotime($post->created_at));
        $postDay = date("d", strtotime($post->created_at));
        $path = env('PHOTOS_URL_FRONT') . '/posts/'. $postYear.'/'.$postMonth.'/'.$postDay;
        File::makeDirectory($path, $mode = 0777, true, true);
        if(File::exists($old_path.$post->img)){
            File::move($old_path.$post->img, $path.'/'.$post->img);
            File::move($old_path.'130x73-'.$post->img, $path.'/130x73-'.$post->img);
            File::move($old_path.'300x169-'.$post->img, $path.'/300x169-'.$post->img);
            File::move($old_path.'398x224-'.$post->img, $path.'/398x224-'.$post->img);
            File::move($old_path.'470x264-'.$post->img, $path.'/470x264-'.$post->img);
            File::move($old_path.'637x358-'.$post->img, $path.'/637x358-'.$post->img);
            File::move($old_path.'970x546-'.$post->img, $path.'/970x546-'.$post->img);
            File::move($old_path.'1200x628-'.$post->img, $path.'/1200x628-'.$post->img);
        }

        for($i=1;$i<=10;$i++){
            if($request->get("img".$i)){
                $gImg=new PostPhoto();
                $gImg->photo=$request->get("img".$i);
                $gImg->post_id=$post->id;
                $gImg->save();

                File::makeDirectory($path, $mode = 0777, true, true);
                if(File::exists($old_path.$gImg->photo)){
                    File::move($old_path.$gImg->photo, $path.'/'.$gImg->photo);
                    File::move($old_path.'130x73-'.$gImg->photo, $path.'/130x73-'.$gImg->photo);
                    File::move($old_path.'300x169-'.$gImg->photo, $path.'/300x169-'.$gImg->photo);
                    File::move($old_path.'398x224-'.$gImg->photo, $path.'/398x224-'.$gImg->photo);
                    File::move($old_path.'470x264-'.$gImg->photo, $path.'/470x264-'.$gImg->photo);
                    File::move($old_path.'637x358-'.$gImg->photo, $path.'/637x358-'.$gImg->photo);
                    File::move($old_path.'970x546-'.$gImg->photo, $path.'/970x546-'.$gImg->photo);
                    File::move($old_path.'1200x628-'.$gImg->photo, $path.'/1200x628-'.$gImg->photo);
                }
            }
        }

        // update sitmap link
        $sitemapLink = new SitemapLink();
        $sitemapLink->UpdateSitemapLink(7,$post->id);

        return response()->json(['redirect'=>route('galleryList')]);
    }


    /**
     * delete an article
     *
     * @param int $postId
     * @return void
     */
    public function deleteArticle($postId){
        $post=Post::find($postId);
        $user = \Auth::user();
        if(!($user->hasRole("Admin") || $user->hasRole("Webmaster") || $user->hasRole("JournalisteWeb")) && $post->status==2){
            abort(403, 'Access denied');
        }

        // delete sitmap link
        $sitemapLink = new SitemapLink();
        $sitemapLink->DeleteSitemapLink(1, $post->id);
        PostViews::where('post_id',$post->id)->delete();
        $post->delete();

        return response()->json(['redirect'=>route('postsList')]);
    }

    /**
     * delete a video
     *
     * @param int $postId
     * @return void
     */
    public function deleteVideo($videoId){
        $post=Post::find($videoId);
        $user = \Auth::user();
        if(!($user->hasRole("Admin") || $user->hasRole("Webmaster") || $user->hasRole("JournalisteWeb")) && $post->status==2){
            abort(403, 'Access denied');
        }

        // delete sitmap link
        $sitemapLink = new SitemapLink();
        $sitemapLink->DeleteSitemapLink(1, $post->id);
        PostViews::where('post_id',$post->id)->delete();
        $post->delete();

        return response()->json(['redirect'=>route('VideosList')]);
    }

    /**
     * delete a gallery
     *
     * @param int $postId
     * @return void
     */
    public function deleteGallery($videoId){
        $post=Post::find($videoId);
        $user = \Auth::user();
        if(!($user->hasRole("Admin") || $user->hasRole("Webmaster") || $user->hasRole("JournalisteWeb")) && $post->status==2){
            abort(403, 'Access denied');
        }

        // delete sitmap link
        $sitemapLink = new SitemapLink();
        $sitemapLink->DeleteSitemapLink(7, $post->id);
        PostViews::where('post_id',$post->id)->delete();
        $post->delete();

        return response()->json(['redirect'=>route('galleryList')]);
    }

    /**
     * @param SearchPostRequest $request
     * @return \Illuminate\Contracts\View\Factory|\Illuminate\View\View
     */
    public function searchArticle(SearchPostRequest $request)
    {

        $user = \Auth::user();
        if(!($user->hasRole("Admin") || $user->hasRole("Webmaster") || $user->hasRole("JournalisteWeb")) && $post->status==2){
            abort(403, 'Access denied');
        }

        $validated = $request->validated();
        $title = $validated["search_post_title"];
        //display result
        $posts=Post::whereType(0)
                    ->where('title', 'LIKE', "%{$title}%")
                    ->latest("created_at")
                    ->with(["tags","user","categories"])
                    ->paginate(100);
        $posts->appends(['search_post_title' => $title]);
        return view('posts.list-articles',compact('posts'), compact('title'));
    }

    /**
     * @param SearchPostRequest $request
     * @return \Illuminate\Contracts\View\Factory|\Illuminate\View\View
     */
    public function searchVideo(SearchPostRequest $request)
    {
        $user = \Auth::user();
        if(!($user->hasRole("Admin") || $user->hasRole("Webmaster") || $user->hasRole("JournalisteWeb")) && $post->status==2){
            abort(403, 'Access denied');
        }
        $validated = $request->validated();
        $title = $validated["search_post_title"];
        //display result
        $posts=Post::whereType(1)
            ->where('title', 'LIKE', "%{$title}%")
            ->latest("created_at")
            ->with(["tags","user","categories"])
            ->paginate(100);
        $posts->appends(['search_post_title' => $title]);//utile pour la pagination
        return view('posts.list-videos',compact('posts'), compact('title'));
    }

    /**
     * @param SearchPostRequest $request
     * @return \Illuminate\Contracts\View\Factory|\Illuminate\View\View
     */
    public function searchGallerie(SearchPostRequest $request)
    {
        $user = \Auth::user();
        if(!($user->hasRole("Admin") || $user->hasRole("Webmaster") || $user->hasRole("JournalisteWeb")) && $post->status==2){
            abort(403, 'Access denied');
        }
        $validated = $request->validated();
        $title = $validated["search_post_title"];
        //display result
        $posts=Post::whereType(2)
            ->where('title', 'LIKE', "%{$title}%")
            ->latest("created_at")
            ->with(["tags","user","categories"])
            ->paginate(100);
        $posts->appends(['search_post_title' => $title]);//utile pour la pagination
        return view('posts.list-gallery',compact('posts'), compact('title'));
    }

    /**
     * list of links for autocomplete
     * @param Request $request
     * @return \Illuminate\Http\JsonResponse
     */
    public function ajxPostLink(Request $request){
        $title = $request->get('term');
        $posts = Post::whereType(0)
            ->where('title', 'LIKE', "%{$title}%")
            ->latest("created_at")
            ->with("categories")
            ->take(10)
            ->select('id', 'title', 'url_rewrite')
        ;

        $result = [];
        foreach ($posts->get() as $post){
            $result[] = [
                'value' => "https://www.diwanfm.net/news/".e($post->categories->first()->url_rewrite).'/'.e($post->url_rewrite),
                'label' => $post->title
                ]
            ;
        }

        //withCallback used for jsonp response
        return response()->json($result)->withCallback($request->input('callback'));
    }

    /**
     * send video in notification
     *
     * @param int $postId
     * @return void
     */
    public function notify($id, $type){
        $post=Post::find($id);
        $this->sendNotification('ArticleDetails', $id, $post->title, $post->summary, $post->url_rewrite, $post->categories[0]['url_rewrite'], $type);
    }

    /**
     * envoyer les notifications concernant un article
     *
     * @return response()
     */
    public function sendNotification($target, $id, $title, $body, $postUrl, $categoryUrl, $type)
    {
        if ($type =="article"){
            $deviceData = DB::table('devices')->where('isActiveArticlesNotifications', 1)->get()->pluck('deviceId')->toArray();
        }else{
            $deviceData = DB::table('devices')->where('isActiveVideosNotifications', 1)->get()->pluck('deviceId')->toArray();
        }

        $SERVER_API_KEY = env('SERVER_KEY');

        $data = [
            "registration_ids" => $deviceData,
            "notification" => [
                "title" => $title,
                "body" => "",
                "sound"=> "default",
            ],
            "data" => [
                "categoryUrl" => $categoryUrl,
                "postUrl" => $postUrl,
                "childRoute" => "ArticleDetails",
                "route" => "News",
                "id" => $id,
                "target" => $target,
                "title" => $title,
            ]
        ];
        $dataString = json_encode($data);

        $headers = [
            'Authorization: key=' . $SERVER_API_KEY,
            'Content-Type: application/json',
        ];

        $ch = curl_init();

        curl_setopt($ch, CURLOPT_URL, 'https://fcm.googleapis.com/fcm/send');
        curl_setopt($ch, CURLOPT_POST, true);
        curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
        curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_POSTFIELDS, $dataString);
        $response = curl_exec($ch);
    }


}
