<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use App\Http\Controllers\Controller;
use App\Http\Requests\CreatePodcastRequest;
use Carbon\Carbon;
use App\Animator;
use App\Program;
use App\ProgramSeance;
use App\Programming;
use App\Podcast;
use App\MP3File;
use App\DevicePodcast;
use App\Device;
use Ramsey\Uuid\Uuid;

class PodcastController extends Controller
{
    /**
     * list podcasts
     *
     * @return void
     */
    public function index(){
        $podcasts=Podcast::latest("created_at")->with("animators")->with("program")->with("programSeance")->paginate(100);
        return view('podcasts.list')->with(compact('podcasts'));
    }

    /**
     * create podcast
     *
     * @return void
     */
    public function newPodcast(){
        $programs=Program::with("programSeances")->get();
        $animators=Animator::get();
        return view('podcasts.create')->with(compact('animators'))->with(compact("programs"));
    }

    /**
     * ajx create request
     *
     * @param CreatePodcastRequest $request
     * @return void
     */
    public function ajxNewPodcast(CreatePodcastRequest $request){

        $podcast=new Podcast();

        $podcast->title=$request->get("title");
        $podcast->meta_title=$request->get("meta_title");
        $podcast->meta_description=$request->get("meta_description");
        $podcast->meta_keywords=$request->get("meta_keywords");
        $podcast->live_date=Carbon::createFromFormat("d/m/Y H:i:s",$request->get("live_date"));
        $storagePath=config("paths.STORAGE_PATH");
        $storagePath=explode("/",$storagePath);
        array_pop($storagePath);
        $storagePath=implode('/',$storagePath);
        $audio = new MP3File($storagePath.'/'.$request->get("mp3_file"));
        $podcast->duration=$audio->getDuration();
        $podcast->status=$request->get("status");
        $podcast->mp3=$request->get("mp3_file");
        $seance=ProgramSeance::find($request->seance);
        $program=$seance->program;
        $podcast->program_id=$program->id;
        $podcast->program_seance_id=$seance->id;
        $podcast->url_rewrite=$request->get("title");
        $podcast->url_rewrite=str_replace(" ",'-',$podcast->url_rewrite);
        $podcast->url_rewrite=urlencode($podcast->url_rewrite);
        $podcastCnt=podcast::where("url_rewrite","REGEXP","{$podcast->url_rewrite}(-[0-9]*)?$")->count();
     

        if($podcastCnt>0){

            /*$uuid1 = Uuid::uuid1();
            $uuid1->toString();
            $rest = substr($uuid1, -8);*/
            $rest = mt_rand();

            $podcast->url_rewrite=$podcast->url_rewrite."-".$rest;
        }
        $podcast->order=0;
        $podcast->save();

        $podcasts = Podcast::whereStatus(1)->where('program_id',$podcast->program_id)->with('program')->orderBy("live_date", "desc")->first();
        $this->sendNotification('PodCastDetails', $podcasts->program_seance_id, $podcasts->program['title'], $podcasts->program['img'], $podcasts->program_id);


        if(is_array($request->get("animator"))){
            foreach($request->get("animator") as $animatorId){
                $animator=Animator::find($animatorId);
                $podcast->animators()->attach($animator);
            }
        }else{
            $animator=Animator::find($request->get("animator"));
            $podcast->animators()->attach($animator);
        }
        
        return response()->json(['redirect'=>route('listPodcasts')]);
    }

    
    /**
     * envoyer les notifications concernant un podcast
     *
     * @return response()
     */
    public function sendNotification($target, $id, $title, $img, $programId)
    {
        $devices = DB::table('devices_podcasts')->where('isActive', 1)->get();
        $devicesArray = array();

        foreach ($devices as $device) {
            $deviceData = Device::select('deviceId')->where('id', $device->deviceId)->first();

            if ($device->seanceId == $id){
                array_push($devicesArray,$deviceData->deviceId);
            }
        }

        $SERVER_API_KEY = env('SERVER_KEY');

        $data = [
            "registration_ids" => $devicesArray,
            "notification" => [
                "title" => $title,
                "body" => "تسجيل جديد",  
                "sound"=> "default",
            ],
            "data" => [
                "id" => $programId,
                "target" => $target, 
                "title" => $title, 
                "img" => $img,
            ]
        ];
        $dataString = json_encode($data);
    
        $headers = [
            'Authorization: key=' . $SERVER_API_KEY,
            'Content-Type: application/json',
        ];
    
        $ch = curl_init();
    
        curl_setopt($ch, CURLOPT_URL, 'https://fcm.googleapis.com/fcm/send');
        curl_setopt($ch, CURLOPT_POST, true);
        curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
        curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_POSTFIELDS, $dataString);
        $response = curl_exec($ch);
    }



/*$uuid1 = Uuid::uuid1();
$uuid1->toString();
$rest = substr($uuid1, -8);
$podcast->url_rewrite=str_replace(" ",'-',$podcast->url_rewrite);
$podcast->url_rewrite=urlencode($podcast->url_rewrite);
$podcast->url_rewrite=implode("", array($rest,$podcast));


return response()->json($podcast); die;*/

    /**
     * edit podcast
     *
     * @param int podcastId
     * @return void
     */
    public function editPodcast($podcastId){
        $programs=Program::with("programSeances")->get();
        $animators=Animator::get();
        $podcast=Podcast::find($podcastId);
        return view('podcasts.edit')->with(compact('animators'))->with(compact("programs"))->with(compact("podcast"));
    }

    /**
     * ajax edit podcast request
     *
     * @param int podcastId
     * @return void
     */
    public function ajxUpdatePodcast(CreatePodcastRequest $request,$podcastId){
        $podcast=Podcast::find($podcastId);

        $podcast->title=$request->get("title");
        $podcast->meta_title=$request->get("meta_title");
        $podcast->meta_description=$request->get("meta_description");
        $podcast->meta_keywords=$request->get("meta_keywords");
        $podcast->live_date=Carbon::createFromFormat("d/m/Y H:i:s",$request->get("live_date"));
        $storagePath=config("paths.STORAGE_PATH");
        $storagePath=explode("/",$storagePath);
        array_pop($storagePath);
        $storagePath=implode('/',$storagePath);
        $audio = new MP3File($storagePath.'/'.$request->get("mp3_file"));
        $podcast->duration=$audio->getDuration();
        $podcast->status=$request->get("status");
        $podcast->mp3=$request->get("mp3_file");
        $seance=ProgramSeance::find($request->seance);
        $program=$seance->program;
        $podcast->program_id=$program->id;
        $podcast->program_seance_id=$seance->id;
        $podcast->save();
        $podcast->animators()->detach();

        if(is_array($request->get("animator"))){
            foreach($request->get("animator") as $animatorId){
                $animator=Animator::find($animatorId);
                $podcast->animators()->attach($animator);
            }
        }else{
            $animator=Animator::find($request->get("animator"));
            $podcast->animators()->attach($animator);
        }

        return response()->json(['redirect'=>route('listPodcasts')]);
    }

    /**
     * delete a podcast
     *
     * @param int $podcastId
     * @return void
     */
    public function deletePodcast($podcastId){
        $podcast=Podcast::find($podcastId);
        $podcast->delete();

        return response()->json(['redirect'=>route('listPodcasts')]);
    }

}
