<?php

namespace App\Http\Controllers;

use Illuminate\Support\Facades\Storage;
use Intervention\Image\Facades\Image;
use Spatie\Async\Async;

use Illuminate\Http\Request;
use Spatie\Async\Pool;

class PhotoController extends Controller
{
    /**
     * @var array $mimeTypes
     * 
     * accepted mime types list
     */
    private $mimeTypes;

    /**
     * @var array $dimentions
     * 
     * list of dimension of any module
     */
    private $dimensions;

    /**
     * Create a new controller instance.
     *
     * @return void
     */
    public function __construct()
    {
        //initialization
        $this->mimeTypes = [
            "image/gif",
            "image/jpeg",
            "image/png"
        ];

        $this->dimensions = [
            "categoryHabillage" => [
                "minSize" => [
                    "w" => 2560,
                    "h" => 1621
                ],
                "path" => "category_habillage",
                "dimensions" => [
                    [
                        "w" => 2560,
                        "h" => 1621
                    ]
                ]
            ],
            "notify" => [
                "minSize" => [
                    "w" => 150,
                    "h" => 150
                ],
                "path" => "notify",
                "dimensions" => [
                    [
                        "w" => 150,
                        "h" => 150
                    ]
                ]
            ],
            "article" => [
                "minSize" => [
                    "w" => 1200,
                    "h" => 675
                ],
                "path" => "posts",
                "dimensions" => [
                    [
                        "w" => 1200,
                        "h" => 628
                    ],
                    [
                        "w" => 970,
                        "h" => 546
                    ],
                    [
                        "w" => 637,
                        "h" => 358
                    ],
                    [
                        "w" => 470,
                        "h" => 264
                    ],
                    [
                        "w" => 398,
                        "h" => 224
                    ],
                    [
                        "w" => 300,
                        "h" => 169
                    ],
                    [
                        "w" => 130,
                        "h" => 73
                    ],
                ]
            ],
            "animator" => [
                "minSize" => [
                    "w" => 1200,
                    "h" => 900
                ],
                "path" => "animators",
                "dimensions" => [
                    [
                        "w" => 1200,
                        "h" => 900
                    ],
                    [
                        "w" => 1200,
                        "h" => 628
                    ],
                    [
                        "w" => 637,
                        "h" => 478
                    ],
                    [
                        "w" => 303,
                        "h" => 227
                    ]
                ]
            ],
            "program" => [
                "minSize" => [
                    "w" => 1200,
                    "h" => 750
                ],
                "path" => "programs",
                "dimensions" => [
                    [
                        "w" => 1200,
                        "h" => 628
                    ],
                    [
                        "w" => 636,
                        "h" => 398
                    ],
                    [
                        "w" => 303,
                        "h" => 189
                    ],
                    [
                        "w" => 303,
                        "h" => 170
                    ],
                ]
            ],
            "programLive" => [
                "minSize" => [
                    "w" => 1200,
                    "h" => 750
                ],
                "path" => "programs",
                "dimensions" => [
                    [
                        "w" => 1200,
                        "h" => 750
                    ]
                ]
            ],
            "marchiCategory" => [
                "minSize" => [
                    "w" => 334,
                    "h" => 331
                ],
                "path" => "marchi/category",
                "dimensions" => [
                    [
                        "w" => 334,
                        "h" => 331
                    ]
                ]
            ],
            "marchiProduct" => [
                "minSize" => [
                    "w" => 334,
                    "h" => 331
                ],
                "path" => "marchi/product",
                "dimensions" => [
                    [
                        "w" => 334,
                        "h" => 331
                    ]
                ]
            ],
            "kids" => [
                "minSize" => [
                    "w" => 220,
                    "h" => 123
                ],
                "path" => "kids",
                "dimensions" => [
                    [
                        "w" => 220,
                        "h" => 123
                    ]
                ]
            ]
        ];
    }

    /**
     * Set images for category Habillage
     * 
     * @return void
     */
    public function categoryHabillage(Request $request)
    {
        $data = array();
        $data["fileExist"] = file_exists(realpath($request->imgPath));
        $data["correctMimeType"] = false;
        $data["correctSize"] = false;
        $data["correctMimeType"] = ($data["fileExist"]) ? $this->checkMimeType($request->imgPath) : false;
        $data["correctSize"] = ($data["correctMimeType"]) ? $this->correctSize($request->imgPath, "categoryHabillage") : false;

        if ($data["correctSize"]) {
            $ext = pathinfo($request->imgPath, PATHINFO_EXTENSION);
            $imgName = uniqid() . uniqid() . "." . $ext;
            $data["imgName"] = $imgName;
            $this->redim($request->imgPath, $imgName, "categoryHabillage");
        } else {
            $data["imgName"] = "";
        }
        return response()->json($data);
    }



public function photoArticle(Request $request) {
    $data = array();
    $data["fileExist"] = file_exists(realpath($request->imgPath));
    $data["correctMimeType"] = false;
    $data["correctSize"] = false;
    $data["imgName"] = "";
    $data["correctMimeType"] = ($data["fileExist"]) ? $this->checkMimeType($request->imgPath) : false;
    $data["correctSize"] = ($data["correctMimeType"]) ? $this->correctSize($request->imgPath, "article") : false;
    if($data["correctSize"]){
        $ext = pathinfo($request->imgPath, PATHINFO_EXTENSION);
        $imgName=uniqid().uniqid().".".$ext;
        $data["imgName"]=$imgName;
        $this->redim($request->imgPath,$imgName,"article");
    }
    return response()->json($data);
}

    
    public function photoNotify(Request $request)
    {
        $data = array();
        $data["fileExist"] = file_exists(realpath($request->imgPath));
        $data["correctMimeType"] = false;
        $data["correctSize"] = false;
        $data["correctMimeType"] = ($data["fileExist"]) ? $this->checkMimeType($request->imgPath) : false;
        $data["correctSize"] = ($data["correctMimeType"]) ? $this->correctSize($request->imgPath, "notify") : false;

        if ($data["correctSize"]) {
            $ext = pathinfo($request->imgPath, PATHINFO_EXTENSION);
            $imgName = uniqid() . uniqid() . "." . $ext;
            $data["imgName"] = $imgName;
            $this->redim($request->imgPath, $imgName, "notify");
        } else {
            $data["imgName"] = "";
        }
        return response()->json($data);
    }
    public function photoAnimator(Request $request)
    {
        $data = array();
        $data["fileExist"] = file_exists(realpath($request->imgPath));
        $data["correctMimeType"] = false;
        $data["correctSize"] = false;
        $data["correctMimeType"] = ($data["fileExist"]) ? $this->checkMimeType($request->imgPath) : false;
        $data["correctSize"] = ($data["correctMimeType"]) ? $this->correctSize($request->imgPath, "animator") : false;

        if ($data["correctSize"]) {
            $ext = pathinfo($request->imgPath, PATHINFO_EXTENSION);
            $imgName = uniqid() . uniqid() . "." . $ext;
            $data["imgName"] = $imgName;
            $this->redim($request->imgPath, $imgName, "animator");
        } else {
            $data["imgName"] = "";
        }
        return response()->json($data);
    }

    public function photoProgram(Request $request)
    {
        $data = array();
        $data["fileExist"] = file_exists(realpath($request->imgPath));
        $data["correctMimeType"] = false;
        $data["correctSize"] = false;
        $data["correctMimeType"] = ($data["fileExist"]) ? $this->checkMimeType($request->imgPath) : false;
        $data["correctSize"] = ($data["correctMimeType"]) ? $this->correctSize($request->imgPath, "program") : false;

        if ($data["correctSize"]) {
            $ext = pathinfo($request->imgPath, PATHINFO_EXTENSION);
            $imgName = uniqid() . uniqid() . "." . $ext;
            $data["imgName"] = $imgName;
            $this->redim($request->imgPath, $imgName, "program");
        } else {
            $data["imgName"] = "";
        }
        return response()->json($data);
    }

    public function photoProgramLive(Request $request)
    {
        $data = array();
        $data["fileExist"] = file_exists(realpath($request->imgPath));
        $data["correctMimeType"] = false;
        $data["correctSize"] = false;
        $data["correctMimeType"] = ($data["fileExist"]) ? $this->checkMimeType($request->imgPath) : false;
        $data["correctSize"] = ($data["correctMimeType"]) ? $this->correctSize($request->imgPath, "programLive") : false;

        if ($data["correctSize"]) {
            $ext = pathinfo($request->imgPath, PATHINFO_EXTENSION);
            $imgName = uniqid() . uniqid() . "." . $ext;
            $data["imgName"] = $imgName;
            $this->redim($request->imgPath, $imgName, "programLive");
        } else {
            $data["imgName"] = "";
        }
        return response()->json($data);
    }

    public function photoMarchiCategory(Request $request)
    {
        $data = array();
        $data["fileExist"] = file_exists(realpath($request->imgPath));
        $data["correctMimeType"] = false;
        $data["correctSize"] = false;
        $data["correctMimeType"] = ($data["fileExist"]) ? $this->checkMimeType($request->imgPath) : false;
        $data["correctSize"] = ($data["correctMimeType"]) ? $this->correctSize($request->imgPath, "marchiCategory") : false;

        if ($data["correctSize"]) {
            $ext = pathinfo($request->imgPath, PATHINFO_EXTENSION);
            $imgName = uniqid() . uniqid() . "." . $ext;
            $data["imgName"] = $imgName;
            $this->redim($request->imgPath, $imgName, "marchiCategory");
        } else {
            $data["imgName"] = "";
        }
        return response()->json($data);
    }

    public function photoMarchiProduct(Request $request)
    {
        $data = array();
        $data["fileExist"] = file_exists(realpath($request->imgPath));
        $data["correctMimeType"] = false;
        $data["correctSize"] = false;
        $data["correctMimeType"] = ($data["fileExist"]) ? $this->checkMimeType($request->imgPath) : false;
        $data["correctSize"] = ($data["correctMimeType"]) ? $this->correctSize($request->imgPath, "marchiProduct") : false;

        if ($data["correctSize"]) {
            $ext = pathinfo($request->imgPath, PATHINFO_EXTENSION);
            $imgName = uniqid() . uniqid() . "." . $ext;
            $data["imgName"] = $imgName;
            $this->redim($request->imgPath, $imgName, "marchiProduct");
        } else {
            $data["imgName"] = "";
        }
        return response()->json($data);
    }
    public function photoKids(Request $request)
    {
        $data = array();
        $data["fileExist"] = file_exists(realpath($request->imgPath));
        $data["correctMimeType"] = false;
        $data["correctSize"] = false;
        $data["correctMimeType"] = ($data["fileExist"]) ? $this->checkMimeType($request->imgPath) : false;
        $data["correctSize"] = ($data["correctMimeType"]) ? $this->correctSize($request->imgPath, "kids") : false;

        if ($data["correctSize"]) {
            $ext = pathinfo($request->imgPath, PATHINFO_EXTENSION);
            $imgName = uniqid() . uniqid() . "." . $ext;
            $data["imgName"] = $imgName;
            $this->redim($request->imgPath, $imgName, "kids");
        } else {
            $data["imgName"] = "";
        }
        return response()->json($data);
    }
    /**
     * check if mime type is correct
     * 
     * @var string $path
     * @return bool
     */
    private function checkMimeType($path)
    {

        return in_array(Image::make($path)->mime(), $this->mimeTypes);
    }

    /**
     * check if image size is correct
     * 
     * @var string $path
     * @var string $dimensionLabel
     * @return bool
     */
    private function correctSize($path, $dimensionLabel)
    {
        $image = Image::make($path);
        return ($image->width() >= $this->dimensions[$dimensionLabel]["minSize"]["w"] && $image->height() >= $this->dimensions[$dimensionLabel]["minSize"]["h"]);
    }

    /**
     * redimension image
     * 
     * make original image and thumbs in the correct folder
     * 
     * @var string $path
     * @var string $imgName
     * @var string $dimensionLabel
     * @return bool
     */
    private function redim($path, $imgName, $dimensionLabel)
    {
        $image = Image::make($path);
        $image->save(config("paths.PHOTOS_PATH") . "/" . $this->dimensions[$dimensionLabel]["path"] . "/" . $imgName);
        foreach ($this->dimensions[$dimensionLabel]["dimensions"] as $oneDim) {
            $resizedImage = clone $image;
            $resizedImage->resize($oneDim["w"], null, function ($constraint) {
                $constraint->aspectRatio();
            });
            $resizedImage->crop($oneDim["w"], $oneDim["h"], 0, 0);
            $resizedImage->save(config("paths.PHOTOS_PATH") . "/" . $this->dimensions[$dimensionLabel]["path"] . "/" . $oneDim["w"] . "x" . $oneDim["h"] . "-" . $imgName);
        }
    }
}
