<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Http\Requests\CreatePageRequest;
use App\Http\Requests\UpdatePageRequest;
use Illuminate\Support\Str;
use App\Page;
use App\SitemapIndex;
use App\SitemapLink;

class PageController extends Controller
{
    /**
     * Create a new controller instance.
     *
     * @return void
     */
    public function __construct()
    {
        
    }

     /**
     * list pages
     * @return void
     */
    public function index(){
    	$pages=Page::get();
    	return view('pages.list',compact('pages'));
    }

    /**
     * new page form
     * 
     * @return void
     */
    public function newPage(){
        return view('pages.create');
    }

    /**
     * create new page ajax request
     * 
     * @param Request $request
     * @return void
     */
    public function ajxNewPage(CreatePageRequest $request){
        $page=new Page();
        $page->title=$request->get("title");
        $page->page_title=$request->get("url_title");
        $page->content=$request->get("content");
        $page->keywords=$request->get("keywords");
        $page->description=$request->get("description");

        $page->alias=$request->get("alias") ? $request->get("alias") : $request->get("title");
        $page->alias=str_replace(" ",'-',$page->alias);
        $page->alias=urlencode($page->alias);
        $pageCnt=Page::where("alias","REGEXP","{$page->alias}(-[0-9]*)?$")->count();
        if($pageCnt>0){
            $page->alias=$page->alias."-".$pageCnt;
        }
        
        $page->save();

        $sitemapLink = new SitemapLink();
        $url = $sitemapLink->getRoutLink(7).$page->alias;
        $sitemapLink->InsertSitemapLink(7,$page->id,$url);

        return response()->json(['redirect'=>route('pagesList')]);
    }

    /**
     * edit page form
     * 
     * @param int $pageId
     * @return void
     */
    public function edit($pageId){
        $page=Page::find($pageId);
        return view('pages.edit')->with(compact("page"));
    }

    /**
     * update page
     * 
     * @param UpdatePageRequest $request
     * @param int $pageId
     * @return void
     */
    public function ajxUpdatePage(UpdatePageRequest $request,$pageId){
        $page=Page::find($pageId);

        $page->title=$request->get("title");
        $page->page_title=$request->get("url_title");
        $page->content=$request->get("content");
        $page->keywords=$request->get("keywords");
        $page->description=$request->get("description");

        $page->alias=$request->get("alias") ? $request->get("alias") : $request->get("title");
        $page->alias=str_replace(" ",'-',$page->alias);
        $page->alias=urlencode($page->alias);
        $pageCnt=Page::where("alias","REGEXP","{$page->alias}(-[0-9]*)?$")->where("id","<>",$pageId)->count();
        if($pageCnt>0){
            $page->alias=$page->alias."-".$pageCnt;
        }
        
        $page->save();

        // update sitmap link
        $sitemapLink = new SitemapLink();
        $sitemapLink->UpdateSitemapLink(7,$page->id);

        return response()->json(['redirect'=>route('pagesList')]);
    }

    /**
     * delete a page
     * 
     * @param int $pageId
     * @return void
     */
    public function delete($pageId){
        $page=Page::find($pageId);

        // delete sitmap link
        $sitemapLink = new SitemapLink();
        $sitemapLink->DeleteSitemapLink(7, $page->id);

        $page->delete();

        return response()->json(['redirect'=>route('pagesList')]);
    }
}
