<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\DB;

class NotifyController extends Controller
{
    public function index () {
        return view('notify.notify');
    }

    public function sendNotification(Request $request){
        if ($request->get("text") != "" || $request->get("img") != ""){
            $title = "صورة";
            if ($request->get("info") == 1){
                $title = "خبر عاجل";
                $deviceData = DB::table('devices')->where("isActiveNewNotifications", 1)->get()->pluck('deviceId')->toArray();
            }else if ($request->get('img') == ""){
                $title = "";
                $deviceData = DB::table('devices')->where("isActiveNewNotifications", 1)->get()->pluck('deviceId')->toArray();
            }else {
                $deviceData = DB::table('devices')->where("isActiveImgNotifications", 1)->get()->pluck('deviceId')->toArray();
            }

            $SERVER_API_KEY = env('SERVER_KEY');
    
            $data = [
                "registration_ids" => $deviceData,
                "notification" => [
                    "title" => $title, 
                    "body" => $request->get("text") ? $request->get("text") : "", 
                    "sound"=> "default",
                ],
                "data" => [
                    "isInfo" => true,
                    "target" => "News", 
                    "route" => "News", 
                    "childRoute" => "News", 
                    "type" => $request->get("info"), 
                    "img" => $request->get("img"), 
                    "text" => $request->get("text") ? $request->get("text") : "", 
                ]
            ];
            $dataString = json_encode($data);
        
            $headers = [
                'Authorization: key=' . $SERVER_API_KEY,
                'Content-Type: application/json',
            ];
        
            $ch = curl_init();
        
            curl_setopt($ch, CURLOPT_URL, 'https://fcm.googleapis.com/fcm/send');
            curl_setopt($ch, CURLOPT_POST, true);
            curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
            curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
            curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
            curl_setopt($ch, CURLOPT_POSTFIELDS, $dataString);
            $response = curl_exec($ch);
        }
        return response()->json(['redirect'=>route('notify')]);
    }

}
