<?php

namespace App\Http\Controllers;

use App\newsletterSubscriptions;
use Illuminate\Http\Request;

class NewsletterSubscriptionsController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $subscriptions=newsletterSubscriptions::latest("created_at")->paginate(100);
        
        return view('newsletter.list')->with(compact('subscriptions'));
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  \App\newsletterSubscriptions  $newsletterSubscriptions
     * @return \Illuminate\Http\Response
     */
    public function destroy(newsletterSubscriptions $newsletterSubscriptions)
    {
        $newsletterSubscriptions->delete();
        
        return response()->json(['redirect'=>route('newsletter')]);
    }
}
