<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Storage;
use Intervention\Image\Facades\Image;
use Carbon\Carbon;

use App\User;
use App\Role;
use App\Category;
use App\Animator;
use App\Program;
use App\Programming;
use App\ProgramSeance;
use App\Podcast;
use App\Post;
use App\Tag;
use App\SitemapIndex;
use App\SitemapLink;

class MigratorController extends Controller
{
    /**
     * Create a new controller instance.
     *
     * @return void
     */
    public function __construct()
    {
        
    }

    /**
     * migrator index page
     * 
     * @return void
     */
    public function index(){
        return view('migrator.index');
    }

    /**
     * migrator users
     * 
     * @return void
     */
    public function getUsers(){
        $content = json_decode(Storage::disk('migrator')->get("users.json"));
        $finalContent=[];
        foreach($content as $oldUser){
            
            $user=new User();
            $oldUser=json_decode($oldUser);
            $user->email=$oldUser->bo_user_login;
            $user->password=bcrypt("diwanfm");
            $user->name=$oldUser->bo_user_nickname;
            $user->created_at=Carbon::createFromTimestamp($oldUser->bo_user_cdate);
            $user->updated_at=Carbon::createFromTimestamp($oldUser->bo_user_udate);
            $user->save();

            if($oldUser->bo_group=="0"){
                $role=Role::find(1);
                $user->roles()->attach($role);
            }elseif($oldUser->bo_group=="1"){
                $role=Role::find(4);
                $user->roles()->attach($role);
            }elseif($oldUser->bo_group=="2"){
                $role=Role::find(3);
                $user->roles()->attach($role);
            }elseif($oldUser->bo_group=="3"){
                $role=Role::find(2);
                $user->roles()->attach($role);
            }elseif($oldUser->bo_group=="4"){
                $role=Role::find(5);
                $user->roles()->attach($role);
            }elseif($oldUser->bo_group=="5"){
                $role=Role::find(6);
                $user->roles()->attach($role);
            }
            $oldUser->newId=$user->id;
            $finalContent[]=$oldUser;
        }
        return response()->json(['users'=>$finalContent]);
    }

    /**
     * migrator categories
     * 
     * @return void
     */
    public function getCategories(){
        $content = json_decode(Storage::disk('migrator')->get("categories.json"));
        $finalContent=[];
        foreach($content as $oldCategory){
            $oldCategory=$oldCategory;
            $category=new Category();
            $category->title=$oldCategory->category_title;
            $category->url_rewrite=$oldCategory->url_rewrite;
            $category->keywords=$oldCategory->keywords;
            $category->news_keywords=$oldCategory->news_keywords;
            $category->meta_title=$oldCategory->meta_title;
            $category->description=$oldCategory->description;
            
            $category->habillage_link=$oldCategory->HABILLAGE_LINK;
            $category->color="1acceb";
            $category->parent_id=0;
            if($oldCategory->HABILLAGE!=""){
                $file=file_get_contents($oldCategory->HABILLAGE);
                $filename=explode("/",$oldCategory->HABILLAGE);
                $filename=$filename[count($filename)-1];
                Storage::disk("frontoff")->put("photos/category_habillage/".$filename,$file);
                $category->habillage=$filename;
            }else{
                $category->habillage="";
            }

            $category->save();

            $sitemapLink = new SitemapLink();
            $url = $sitemapLink->getRoutLink(2).$category->url_rewrite;
            $sitemapLink->InsertSitemapLink(2,$category->id,$url);

            $sitemapLink = new SitemapLink();
            $url = $sitemapLink->getRoutLink(3).$category->url_rewrite;
            $sitemapLink->InsertSitemapLink(3,$category->id,$url);

            $oldCategory->newId=$category->id;
            $finalContent[]=$oldCategory;
            
        }

        return response()->json(['categories'=>$finalContent]);
    }

    /**
     * migrator animators
     * 
     * @return void
     */
    public function getAnimators(){
        $content = json_decode(Storage::disk('migrator')->get("animators.json"));
        $finalContent=[];
        foreach($content as $old){
            $old=json_decode($old);
            $animator=new Animator();
            $animator->name=$old->animator_name;
            $animator->description=$old->animator_description;
            $animator->meta_description=$old->animator_description;
            $animator->url_rewrite=$old->animator_url_rewrite;
            $animator->meta_keywords="";
            $animator->img_alt="";
            $animator->public=1;
            $animator->img=$old->animator_id.".jpg";
            $animator->tag="";
            $animator->save();

            $sitemapLink = new SitemapLink();
            $url = $sitemapLink->getRoutLink(6).$animator->url_rewrite;
            $sitemapLink->InsertSitemapLink(6,$animator->id,$url);
            

            $file=file_get_contents("http://old.diwanfm.net/upload/animator/".$old->animator_id.".jpg");
            Storage::disk("frontoff")->put("photos/animators/".$old->animator_id.".jpg",$file);

            $image=Image::make($file);
            $image->resize(1200,null,function($constraint){
                $constraint->aspectRatio();
            });
            $image->crop(1200,900,0,0);
            $image->save("../../diwanfm-frontoff/public/photos/animators/1200x900-".$old->animator_id.".jpg");

            $image=Image::make($file);
            $image->resize(1200,null,function($constraint){
                $constraint->aspectRatio();
            });
            $image->crop(1200,628,0,0);
            $image->save("../../diwanfm-frontoff/public/photos/animators/1200x628-".$old->animator_id.".jpg");

            $image=Image::make($file);
            $image->resize(637,null,function($constraint){
                $constraint->aspectRatio();
            });
            $image->crop(637,478,0,0);
            $image->save("../../diwanfm-frontoff/public/photos/animators/637x478-".$old->animator_id.".jpg");

            $image=Image::make($file);
            $image->resize(303,null,function($constraint){
                $constraint->aspectRatio();
            });
            $image->crop(303,227,0,0);
            $image->save("../../diwanfm-frontoff/public/photos/animators/303x227-".$old->animator_id.".jpg");

            $old->newId=$animator->id;
            $finalContent[]=$old;
        }
        return response()->json(['animators'=>$finalContent]);
    }

    /**
     * migrator programs
     * 
     * @return void
     */
    public function getPrograms(){
        $content = json_decode(Storage::disk('migrator')->get("programs.json"));
        $finalContent=[];
        foreach($content as $old){
            $old=json_decode($old);
            $finalContent[]=$old;
        }
        return response()->json(['programs'=>$finalContent]);
    }

    /**
     * migrator programs
     * 
     * @param Request $request
     * @return void
     */
    public function saveProgram(Request $request){
        $record=json_decode($request->get("record"));
        $program=new Program();
        $program->title=$record->program->program_title;
        $program->meta_title=$record->program->program_title;
        $program->summary = $record->program->program_content;
        $program->summary = strip_tags($program->summary);
        $program->content = $record->program->program_content;
        $program->content = strip_tags($program->content);
        $program->meta_description=$record->program->program_content;
        $program->url_rewrite=urlencode($record->program->program_url_rewrite);
        $program->img=$record->program->program_id.".jpg";
        $program->meta_keywords="";
        $program->img_live="";
        $program->order=0;
        $program->status=$record->program->program_status;
        $program->img_alt=$record->program->program_title;
        $program->views=0;
        
        $program->save();

        $animator=Animator::whereName($record->program->program_animator)->first();
        if($animator){
            $program->animators()->attach($animator);
        }

        // add sitemap index
        $sitemapLink = new SitemapLink();
        $url = $sitemapLink->getRoutLink(5).$program->url_rewrite;
        $sitemapLink->InsertSitemapLink(5,$program->id,$url);

        try{
            $file=file_get_contents("http://old.diwanfm.net/upload/program/".$record->program->program_id.".jpg");
            Storage::disk("frontoff")->put("photos/programs/".$record->program->program_id.".jpg",$file);


            $image=Image::make($file);
            $image->resize(1200,null,function($constraint){
                $constraint->aspectRatio();
            });
            $image->crop(1200,628,0,0);
            $image->save("../../diwanfm-frontoff/public/photos/programs/1200x628-".$record->program->program_id.".jpg");

            $image=Image::make($file);
            $image->resize(636,null,function($constraint){
                $constraint->aspectRatio();
            });
            $image->crop(636,398,0,0);
            $image->save("../../diwanfm-frontoff/public/photos/programs/636x398-".$record->program->program_id.".jpg");

            $image=Image::make($file);
            $image->resize(303,null,function($constraint){
                $constraint->aspectRatio();
            });
            $image->crop(303,189,0,0);
            $image->save("../../diwanfm-frontoff/public/photos/programs/303x189-".$record->program->program_id.".jpg");

            $image=Image::make($file);
            $image->resize(303,null,function($constraint){
                $constraint->aspectRatio();
            });
            $image->crop(303,170,0,0);
            $image->save("../../diwanfm-frontoff/public/photos/programs/303x170-".$record->program->program_id.".jpg");
        }catch(\Exception $e){

        }

        foreach($record->programming as $oldProgramming){
            if($oldProgramming->programming_day!=""){
                $programming=new Programming();
                $programming->program_id=$program->id;
                $programming->day=$oldProgramming->programming_day;
                $programming->start_time=$oldProgramming->programming_time_start;
                $programming->end_time=$oldProgramming->programming_time_end;
                $programming->onair=$oldProgramming->programming_onair;

                $programming->save();
            }
        }

        $record->newProgram=$program;
        $record->newID=$program->id;
        return response()->json(['program'=>$record]);
        
    }

    /**
     * migrator programs seances
     * 
     * @return void
     */
    public function getProgramsSeances(){
        $content = json_decode(Storage::disk('migrator')->get("programsseances.json"));
        $finalContent=[];
        foreach($content as $old){
            $old=json_decode($old);
            $finalContent[]=$old;
        }
        return response()->json(['programsSeances'=>$finalContent]);
    }

    /**
     * migrator programs
     * 
     * @param Request $request
     * @return void
     */
    public function saveProgramSeance(Request $request){
        $oldSeance=json_decode($request->get("seance"));
        $programSeance=new ProgramSeance();
        $programSeance->program_id=$request->get("program");
        $programSeance->title=$oldSeance->progcategory_title;
        $programSeance->meta_title=$oldSeance->progcategory_title;
        $programSeance->meta_description=$oldSeance->progcategory_title;
        $programSeance->url_rewrite=$oldSeance->progcategory_url_rewrite;
        $programSeance->order=0;
        $programSeance->meta_keywords="";
        
        $programSeance->save();

        $oldSeance->newSeance=$programSeance;
        $oldSeance->newID=$programSeance->id;

        return response()->json(['programSeance'=>$oldSeance]);
    }

    /**
     * migrator podcasts
     * 
     * @return void
     */
    public function getPodcasts(){
        $content = json_decode(Storage::disk('migrator')->get("podcasts.json"));
        $finalContent=[];
        foreach($content as $old){
            $old=json_decode($old);
            $finalContent[]=$old;
        }
        return response()->json(['podcasts'=>$finalContent]);
    }

    /**
     * migrator save podcast
     * 
     * @param Request $request
     * @return void
     */
    public function savePodcast(Request $request){
        $oldPodcast=json_decode($request->get("podcast"));
        $podcast=new Podcast();
        $podcast->program_id=$request->get("program");
        $podcast->program_seance_id=$request->get("seance");
        $podcast->title=$oldPodcast->podcast_title;
        $podcast->meta_title=$oldPodcast->podcast_title;
        $podcast->meta_description=$oldPodcast->podcast_title;
        $podcast->live_date=Carbon::createFromTimestamp($oldPodcast->podcast_date)->format("Y-m-d H:i:s");
        $podcast->duration=$oldPodcast->podcast_duration;
        $podcast->status=$oldPodcast->podcast_status;
        $podcast->mp3="stockage/files/".$oldPodcast->podcast_id.".mp3";
        $podcast->url_rewrite=$oldPodcast->podcast_url_rewrite;
        $podcast->meta_keywords="";
        $podcast->order=0;
        $podcast->views=0;
        $podcast->weekly_views=0;
        $podcast->monthly_views=0;
        $podcast->created_at=Carbon::createFromTimestamp($oldPodcast->podcast_date);
        $podcast->updated_at=Carbon::createFromTimestamp($oldPodcast->podcast_date);
        
        $podcast->save();

        /*$file=file_get_contents("http://www.diwanfm.net/upload/podcast/".$request->get("program")."/".$request->get("seance")."/".$oldPodcast->podcast_id.".mp3");
        Storage::disk("frontoff")->put("stockage/files/".$oldPodcast->podcast_id.".mp3",$file);*/

        $oldPodcast->newPodcast=$podcast;
        $oldPodcast->newID=$podcast->id;

        return response()->json(['podcast'=>$oldPodcast]);
    }

    /**
     * migrator posts
     * @param Request $request
     * @return void
     */
    /*public function getPosts(Request $request){
        $content = json_decode(Storage::disk('migrator')->get("posts-".$request->get("part").".json"));
        $finalContent=[];
        foreach($content as $old){
            //$old=json_decode($old);
            $finalContent[]=$old;
        }
        return response()->json(['posts'=>$finalContent]);
    }*/

    public function getPosts(Request $request){
        $content = Storage::disk('migrator')->get("posts-".$request->get("part").".json");
        $content=str_replace(",[]","",$content);
        $content=str_replace("[]","",$content);
        $content=str_replace(",,","",$content);
        $content=str_replace("\'","'",$content);
        $content=str_replace("&bdquo;","bdquo;",$content);
        $content=str_replace("[,","[",$content);
        $content=json_decode($content);
        $finalContent=[];
        foreach($content as $old){
            $finalContent[]=$old;

            $record=$old;
            $post=new Post();
            $user=User::whereEmail($record->post->bo_user_login)->first();
            $post->user_id=$user->id;
            $post->title=str_replace("bdquo;",'&bdquo;',$record->post->post_title);
            $post->summary=str_replace("bdquo;",'&bdquo;',$record->post->post_summary);
            $post->content=str_replace("bdquo;",'&bdquo;',$record->post->post_content);
            $post->meta_title=str_replace("bdquo;",'&bdquo;',$record->post->post_title);
            $post->meta_description=str_replace("bdquo;",'&bdquo;',$record->post->post_summary);
            $post->meta_keywords=$record->post->keywords;
            $post->meta_news_keywords=$record->post->news_keywords;
            $post->url_rewrite=$record->post->post_url_rewrite;
            $post->img=$record->post->post_img;
            $post->img_alt=$record->post->cover_img_alt;
            $post->type=1;
            $post->status=$record->post->post_status;
            $post->flash_news=0;
            $post->facebook_instant_article=0;
            $post->google_amp=0;
            $post->video_url="";
            $post->video_source=0;
            $post->views=0;
            $post->last_news=0;
            $post->last_news_date=NULL;
            $post->published=Carbon::createFromTimestamp($record->post->post_pdate);
            $post->created_at=Carbon::createFromTimestamp($record->post->post_cdate);
            $post->updated_at=Carbon::createFromTimestamp($record->post->post_udate);
            
            $post->save();

            $tags=explode(" ",$record->post->post_tags);
            foreach($tags as $oneTag){
                if($oneTag!="" && $oneTag!=" "){
                    $tag=Tag::find($oneTag);
                    if(!$tag){
                        $tag=new Tag();
                        $tag->title=$oneTag;
                        $tag->url_rewrite=$oneTag;
                        $tag->url_rewrite=str_replace(" ",'-',$tag->url_rewrite);
                        $tag->url_rewrite=urlencode($tag->url_rewrite);
                        $tagCnt=Tag::where("url_rewrite","REGEXP","{$tag->url_rewrite}(-[0-9]*)?$")->count();
                        if($tagCnt>0){
                            $tag->url_rewrite=$tag->url_rewrite."-".$tagCnt;
                        }
                        $tag->save();

                        $sitemapLink = new SitemapLink();
                        $url = $sitemapLink->getRoutLink(4).$tag->url_rewrite;
                        $sitemapLink->InsertSitemapLink(4,$tag->id,$url);
                    }

                    $post->tags()->attach($tag);
                }
            }

            foreach($record->categories as $cat){
                $category=Category::whereTitle($cat)->first();
                $post->categories()->attach($category);
            }

            try{
                //$file=file_get_contents("http://www.diwanfm.net/upload/post/".$record->post->post_id."/cover"."/".$post->img);
                $file = Storage::disk('oldSitePhotos')->get("post/13776/cover/9faceb50198278d79707ac523bf6fc7b.jpg");
                Storage::disk("frontoff")->put("photos/posts/".$post->img,$file);

                $image=Image::make($file);
                $image->resize(1200,null,function($constraint){
                    $constraint->aspectRatio();
                });
                $image->crop(1200,628,0,0);
                $image->save("../../diwanfm-frontoff/public/photos/posts/1200x628-".$post->img);

                $image=Image::make($file);
                $image->resize(970,null,function($constraint){
                    $constraint->aspectRatio();
                });
                $image->crop(970,546,0,0);
                $image->save("../../diwanfm-frontoff/public/photos/posts/970x546-".$post->img);

                $image=Image::make($file);
                $image->resize(637,null,function($constraint){
                    $constraint->aspectRatio();
                });
                $image->crop(637,358,0,0);
                $image->save("../../diwanfm-frontoff/public/photos/posts/637x358-".$post->img);

                $image=Image::make($file);
                $image->resize(470,null,function($constraint){
                    $constraint->aspectRatio();
                });
                $image->crop(470,264,0,0);
                $image->save("../../diwanfm-frontoff/public/photos/posts/470x264-".$post->img);

                $image=Image::make($file);
                $image->resize(398,null,function($constraint){
                    $constraint->aspectRatio();
                });
                $image->crop(398,224,0,0);
                $image->save("../../diwanfm-frontoff/public/photos/posts/398x224-".$post->img);

                $image=Image::make($file);
                $image->resize(300,null,function($constraint){
                    $constraint->aspectRatio();
                });
                $image->crop(300,169,0,0);
                $image->save("../../diwanfm-frontoff/public/photos/posts/300x224-".$post->img);

                $image=Image::make($file);
                $image->resize(130,null,function($constraint){
                    $constraint->aspectRatio();
                });
                $image->crop(130,73,0,0);
                $image->save("../../diwanfm-frontoff/public/photos/posts/130x73-".$post->img);

            }catch(\Exception $e){

            }
        }
        return response()->json(['posts'=>$finalContent]);
    }

    /**
     * migrator save post
     * 
     * @param Request $request
     * @return void
     */
    public function savePost(Request $request){
        $record=json_decode($request->get("record"));
        if(!is_object($record)){
            $record=str_replace("%22","bdquo",$request->get("record"));
            $record=json_decode($record);
            $record->post->post_url_rewrite=str_replace("bdquo","%22",$record->post->post_url_rewrite);
        }
        $post=new Post();
        $user=User::whereEmail($record->post->bo_user_login)->first();
        $post->user_id=$user->id;
        $post->title=str_replace("bdquo;",'&bdquo;',$record->post->post_title);
        $post->summary=str_replace("bdquo;",'&bdquo;',$record->post->post_summary);
        $post->content=str_replace("bdquo;",'&bdquo;',$record->post->post_content);
        $post->meta_title=str_replace("bdquo;",'&bdquo;',$record->post->post_title);
        $post->meta_description=str_replace("bdquo;",'&bdquo;',$record->post->post_summary);
        $post->meta_keywords=$record->post->keywords;
        $post->meta_news_keywords=$record->post->news_keywords;
        $post->url_rewrite=$record->post->post_url_rewrite;
        $post->img=$record->post->post_img;
        $post->img_alt=$record->post->cover_img_alt;
        $post->type=1;
        $post->status=$record->post->post_status;
        $post->flash_news=0;
        $post->facebook_instant_article=0;
        $post->google_amp=0;
        $post->video_url="";
        $post->video_source=0;
        $post->views=0;
        $post->last_news=0;
        $post->last_news_date=NULL;
        $post->published=Carbon::createFromTimestamp($record->post->post_pdate);
        $post->created_at=Carbon::createFromTimestamp($record->post->post_cdate);
        $post->updated_at=Carbon::createFromTimestamp($record->post->post_udate);
        
        $post->save();

        $tags=explode(" ",$record->post->post_tags);
        foreach($tags as $oneTag){
            if($oneTag!="" && $oneTag!=" "){
                $tag=Tag::find($oneTag);
                if(!$tag){
                    $tag=new Tag();
                    $tag->title=$oneTag;
                    $tag->url_rewrite=$oneTag;
                    $tag->url_rewrite=str_replace(" ",'-',$tag->url_rewrite);
                    $tag->url_rewrite=urlencode($tag->url_rewrite);
                    $tagCnt=Tag::where("url_rewrite","REGEXP","{$tag->url_rewrite}(-[0-9]*)?$")->count();
                    if($tagCnt>0){
                        $tag->url_rewrite=$tag->url_rewrite."-".$tagCnt;
                    }
                    $tag->save();

                    $sitemapLink = new SitemapLink();
                    $url = $sitemapLink->getRoutLink(4).$tag->url_rewrite;
                    $sitemapLink->InsertSitemapLink(4,$tag->id,$url);
                }

                $post->tags()->attach($tag);
            }
        }

        foreach($record->categories as $cat){
            $category=Category::whereTitle($cat)->first();
            $post->categories()->attach($category);
        }

        try{
            $file=file_get_contents("http://old.diwanfm.net/upload/post/".$record->post->post_id."/cover"."/".$post->img);
            Storage::disk("frontoff")->put("photos/posts/".$post->img,$file);

            $image=Image::make($file);
            $image->resize(1200,null,function($constraint){
                $constraint->aspectRatio();
            });
            $image->crop(1200,628,0,0);
            $image->save("../../diwanfm-frontoff/public/photos/posts/1200x628-".$post->img);

            $image=Image::make($file);
            $image->resize(970,null,function($constraint){
                $constraint->aspectRatio();
            });
            $image->crop(970,546,0,0);
            $image->save("../../diwanfm-frontoff/public/photos/posts/970x546-".$post->img);

            $image=Image::make($file);
            $image->resize(637,null,function($constraint){
                $constraint->aspectRatio();
            });
            $image->crop(637,358,0,0);
            $image->save("../../diwanfm-frontoff/public/photos/posts/637x358-".$post->img);

            $image=Image::make($file);
            $image->resize(470,null,function($constraint){
                $constraint->aspectRatio();
            });
            $image->crop(470,264,0,0);
            $image->save("../../diwanfm-frontoff/public/photos/posts/470x264-".$post->img);

            $image=Image::make($file);
            $image->resize(398,null,function($constraint){
                $constraint->aspectRatio();
            });
            $image->crop(398,224,0,0);
            $image->save("../../diwanfm-frontoff/public/photos/posts/398x224-".$post->img);

            $image=Image::make($file);
            $image->resize(300,null,function($constraint){
                $constraint->aspectRatio();
            });
            $image->crop(300,169,0,0);
            $image->save("../../diwanfm-frontoff/public/photos/posts/300x224-".$post->img);

            $image=Image::make($file);
            $image->resize(130,null,function($constraint){
                $constraint->aspectRatio();
            });
            $image->crop(130,73,0,0);
            $image->save("../../diwanfm-frontoff/public/photos/posts/130x73-".$post->img);

        }catch(\Exception $e){

        }

        return response()->json(['post'=>$post]);
        
    }
}
