<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Http\Requests\CreateMenuRequest;
use App\Http\Requests\UpdateMenuRequest;
use App\Http\Requests\CreateMenuMobileRequest;
use Illuminate\Support\Facades\DB;

use App\Menu;
use App\DrawerMobileApp;
use App\TagsMobile;

class MenuController extends Controller
{
    /**
     * Create a new controller instance.
     *
     * @return void
     */
    public function __construct()
    {
        
    }

    /**
     * menu list by tag
     * 
     * @param string $tag
     * @return void
     */
    public function list($tag){
        $menus=Menu::whereTag($tag)->whereParent(0)->orderBy("order",'asc')->get();
        $list=array();
        
        foreach($menus as $menu){
            $menu->childs=Menu::whereTag($tag)->whereParent($menu->id)->orderBy("order","asc")->get();
            $list[]=$menu;
        }        
        return view('menus.list',["tag"=>$tag,"menus"=>$list]);
    }
    /**
     * menu list by tag
     * 
     * @return void
     */
    public function listMobile(){
        $menus = DB::table('drawerMobileApp')->whereParent(0)->orderBy("order",'asc')->get();
        $list=array();
        foreach($menus as $menu){
            $menu->childs = DB::table('drawerMobileApp')->whereParent($menu->id)->orderBy("order","asc")->get();
            $list[]=$menu;
        }        
        return view('menus.applicationMobile',["menus"=>$list]);
    }
    /**
     * menu list des tags
     * 
     * @param string $tag
     * @return void
     */
    public function listMobileTags(){
        $menus = DB::table('tags_mobiles')->orderBy("order",'asc')->get();
        $list=array();
        foreach($menus as $menu){
            $menu->childs = DB::table('tags_mobiles')->whereParent($menu->id)->orderBy("order","asc")->get();
            $list[]=$menu;
        }        
        return view('menus.applicationMobileTags',["menus"=>$list]);
    }

    /**
     * update menu list
     * 
     * @param Request $request
     * @param string $tag
     */
    public function ajxUpdatelist(Request $request,$tag){
        $list=json_decode($request->get("list"));
        $i=1;
        foreach($list as $line){
            $menu=Menu::find($line->id);
            $menu->order=$i;
            $menu->parent=0;
            $menu->save();
            $i++;
            if(isset($line->children)){
                foreach($line->children as $child){
                    $menu=Menu::find($child->id);
                    $menu->order=$i;
                    $menu->parent=$line->id;
                    $menu->save();
                    $i++;
                }
            }
        }

        return response()->json(['redirect'=>route('menus',["tag"=>$tag])]);
    }

    /**
     * update menu list mobile 
     * 
     * @param Request $request
     * @param string $tag
     */
    public function ajxUpdatelistMobile(Request $request){
        $list=json_decode($request->get("list"));
        $i=1;
        foreach($list as $line){
            $menu=DrawerMobileApp::find($line->id);
            $menu->order=$i;
            $menu->parent=0;
            $menu->save();
            $i++;
            if(isset($line->children)){
                foreach($line->children as $child){
                    $menu=DrawerMobileApp::find($child->id);
                    $menu->order=$i;
                    $menu->parent=$line->id;
                    $menu->save();
                    $i++;
                }
            }
        }

        return response()->json(['redirect'=>route('menuMobile')]);
    }

    /**
     * update menu list mobile Tag
     * 
     * @param Request $request
     * @param string $tag
     */
    public function ajxUpdatelistMobileTags(Request $request){
        $list=json_decode($request->get("list"));
        $i=1;
        foreach($list as $line){
            $menu=TagsMobile::find($line->id);
            $menu->order=$i;
            $menu->parent=0;
            $menu->save();
            $i++;
            if(isset($line->children)){
                foreach($line->children as $child){
                    $menu=TagsMobile::find($child->id);
                    $menu->order=$i;
                    $menu->parent=$line->id;
                    $menu->save();
                    $i++;
                }
            }
        }

        return response()->json(['redirect'=>route('menuMobileTags')]);
    }

    /**
     * add a new menu form
     * 
     * @param strig $tag
     * @return void
     */
    public function newMenu($tag){
        return view('menus.create',["tag"=>$tag]);
    }

    /**
     * add a new menu Mobile form
     * 
     * @param strig $tag
     * @return void
     */
    public function newMenuMobile(){
        $categories = DB::table('categories')->where('isActive', 1)->get();
        return view('menus.createMobile')
                ->with(compact('categories'));
    }

    /**
     * add a new menu Mobile form
     * 
     * @param strig $tag
     * @return void
     */
    public function newMenuMobileTags(){
        $tags = DB::table('tags')->get();
        
        return view('menus.createMobileTags')->with(compact("tags"));
    }

    /**
     * add new menu request
     * 
     * @param CreateMenuRequest $request
     * @param string $tag
     * 
     * @return void
     */
    public function ajxNewMenu(CreateMenuRequest $request, $tag){
        $cntMenu=Menu::where("tag",$tag)->count();
        $cntMenu++;
        $menu=new Menu();
        $menu->title=$request->get("title");
        $menu->link=$request->get("link");
        $menu->order=$cntMenu;
        $menu->tag=$tag;
        $menu->external=0;
        $menu->parent=0;
        $menu->save();

        return response()->json(['redirect'=>route('menus',['tag'=>$tag])]);
    }

    /**
     * add new menu mobile request
     * 
     * @param CreateMenuMobileRequest $request
     * 
     * @return void
     */
    public function ajxNewMenuMobile(CreateMenuMobileRequest $request){
        $cntMenu = DB::table('drawerMobileApp')->count();
        $cntMenu++;
        $menu=new DrawerMobileApp();
        $menu->title=$request->get("title");
        $menu->category_id=$request->get("categorie");
        $menu->color=$request->get("color");
        $menu->order=$cntMenu;
        $menu->external=0;
        $menu->parent=0;
        $menu->save();
        return response()->json(['redirect'=>route('menuMobile')]);
    }

    /**
     * add new menu mobile request
     * 
     * @param CreateMenuMobileRequest $request
     * 
     * @return void
     */
    public function ajxNewMenuMobileTags(Request $request){
        
        $title = $request->get("title");
        $tags = $request->get("tags");
        $tag_id = $tags[0];

        $cntMenu = TagsMobile::count();
        $cntMenu++;

        $menu=new TagsMobile();
        $menu->title=$title;
        $menu->tag_id=$tag_id;
        $menu->order=$cntMenu;
        $menu->parent=0;
        $menu->save();


        $menus = DB::table('tags_mobiles')->orderBy("order",'asc')->get();
        $list=array();
        foreach($menus as $menu){
            $menu->childs = DB::table('tags_mobiles')->whereParent($menu->id)->orderBy("order","asc")->get();
            $list[]=$menu;
        }        
        return response()->json(['redirect'=>route('menuMobileTags')]);
    }


    /**
     * edit menu
     * @param $tag
     * @param $menuId
     * 
     * @return void
     */
    public function edit($tag,$menuId){
        $menu=Menu::find($menuId);
        return view('menus.edit')->with(compact("menu"))->with(compact("tag"));
    }

    /**
     * edit menu
     * @param $menuId
     * 
     * @return void
     */
    public function editMobile($menuId){
        $categories = DB::table('categories')->where('isActive', 1)->get();
      
        $menu=DrawerMobileApp::find($menuId);
        return view('menus.editMobile')->with(compact("menu"))->with(compact('categories'));
    }

    /**
     * edit menu tag
     * @param $menuId
     * 
     * @return void
     */
    public function editMobileTags($menuId){
        $tags = DB::table('tags')->get();
        $menu = DB::table('tags_mobiles')->find($menuId);
        return view('menus.editMobileTag')->with(compact("menu"))->with(compact("tags"));
    }

    /**
     * update menu
     * @param UpdateMenuRequest $request
     * @param string @tag
     * @param int @menuId
     * 
     * @return void
     */
    public function ajaxUpdateMenu(UpdateMenuRequest $request,$tag,$menuId){
        $menu=Menu::find($menuId);
        $menu->title=$request->get("title");
        $menu->link=$request->get("link");
        $menu->save();

        return response()->json(['redirect'=>route('menus',['tag'=>$tag])]);
    }

    /**
     * update menu mobile
     * @param UpdateMenuRequest $request
     * @param int @menuId
     * 
     * @return void
     */
    public function ajaxUpdateMenuMobile(CreateMenuMobileRequest $request,$menuId){
        $menu=DrawerMobileApp::find($menuId);
        $menu->title=$request->get("title");
        $menu->category_id=$request->get("categorie");
        $menu->color=$request->get("color");
        $menu->save();

        return response()->json(['redirect'=>route('menuMobile')]);
    }

    /**
     * update menu mobile
     * @param UpdateMenuRequest $request
     * @param int @menuId
     * 
     * @return void
     */
    public function ajaxUpdateMenuMobileTags(Request $request,$menuId){
        $menu=TagsMobile::find($menuId);
        $menu->title=$request->get("title");
        $tags = $request->get("tags");
        $tag_id = $tags[0];
        $menu->tag_id=$tag_id;
        $menu->save();

        return response()->json(['redirect'=>route('menuMobileTags')]);
    }

    /**
     * delete a menu
     * 
     * @param string $tag
     * @param int $menuId
     * @return void
     */
    public function delete($tag,$menuId){
        $menu=Menu::find($menuId);
        $order=$menu->order;
        $menu->delete();
        $menus=Menu::whereTag($tag)->where("order",'>',$order)->orderBy("order",'asc')->get();
        foreach($menus as $menu){
            $menu->order=$menu->order-1;
            $menu->save();
        }

        return response()->json(['redirect'=>route('menus',["tag"=>$tag])]);
    }

    /**
     * delete a menu
     * 
     * @param int $menuId
     * @return void
     */
    public function deleteMobile($menuId){
        $menu=DrawerMobileApp::find($menuId);
        $order=$menu->order;
        $menu->delete();
        $menus=DrawerMobileApp::where("order",'>',$order)->orderBy("order",'asc')->get();
        foreach($menus as $menu){
            $menu->order=$menu->order-1;
            $menu->save();
        }

        $menus = DB::table('drawerMobileApp')->whereParent(0)->orderBy("order",'asc')->get();
        $list=array();
        foreach($menus as $menu){
            $menu->childs = DB::table('drawerMobileApp')->whereParent($menu->id)->orderBy("order","asc")->get();
            $list[]=$menu;
        }        
        return response()->json(['redirect'=>route('menuMobile')]);
    }

    /**
     * delete a menu tag menu
     * 
     * @param int $menuId
     * @return void
     */
    public function deleteMobileTags($menuId){
        $menu = TagsMobile::find($menuId);
        $order=$menu->order;
        $menu->delete();
        $menus=TagsMobile::orderBy("order",'asc')->get();
        foreach($menus as $menu){
            $menu->order=$menu->order-1;
            $menu->save();
        }
        return response()->json(['redirect'=>route('menuMobileTags')]);
    }
    

}
