<?php

namespace App\Http\Controllers;

use App\MarchiPrice;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Storage;
use Intervention\Image\Facades\Image;
use Carbon\Carbon;

use App\MarchiCategory;
use App\MarchiProduct;

class MarchiMigratorController extends Controller
{
    /**
     * migrator index page
     *
     * @return void
     */
    public function index()
    {
        return view('migrator.marchi');
    }

    public function getMarchiCategories()
    {
        $content = Storage::disk('migrator')->get("marchicategories.json");
        $content = str_replace('"{', '{', $content);
        $content = str_replace('}"', '}', $content);
        $content = str_replace('\"', '"', $content);
        $content = json_decode($content);
        $finalContent = [];
        foreach ($content as $oldCategory) {
            $oldCategory = $oldCategory;
            $category = new MarchiCategory();
            $category->title = $oldCategory->label;

            if ($oldCategory->photo != "") {
                $file = file_get_contents("http://old.diwanfm.net/upload/marchi/categorie/" . $oldCategory->photo);
                $filename = explode("/", $oldCategory->photo);
                $filename = $filename[count($filename) - 1];
                Storage::disk("frontoff")->put("photos/marchi/category/" . $filename, $file);
                $category->img = $filename;
                $category->img_alt = $filename;
            } else {
                $category->img = "";
                $category->img_alt = "";
            }

            $category->url_rewrite = $oldCategory->url_rewrite;
            $category->summary = $oldCategory->presentation;
            $category->meta_title = $oldCategory->label;
            $category->meta_keywords = "";
            $category->meta_description = $oldCategory->presentation;
            $category->order = $oldCategory->rank;
            $category->save();

            $oldCategory->newID = $category->id;
            $finalContent[] = $oldCategory;
        }


        return response()->json(['categories' => $finalContent]);
    }

    public function getMarchiProducts()
    {
        $content = json_decode(utf8_encode(Storage::disk('migrator')->get("marchiproducts.json")));
        $finalContent = [];
        foreach ($content as $old) {
            $finalContent[] = $old;
        }
        return response()->json(['products' => $finalContent]);
    }

    public function saveMarchiProducts(Request $request)
    {
        $record = json_decode($request->get("record"));
        $category_id = json_decode($request->get("category"));
        $product = new MarchiProduct();
        $product->title = $record->label;
        if ($record->photo != "") {
            $file = file_get_contents("http://old.diwanfm.net/upload/marchi/produit/" . $record->photo);
            $filename = explode("/", $record->photo);
            $filename = $filename[count($filename) - 1];
            Storage::disk("frontoff")->put("photos/marchi/product/" . $filename, $file);
            $product->img = $filename;
            $product->img_alt = $filename;
        } else {
            $product->img = "";
            $product->img_alt = "";
        }
        $product->url_rewrite = urlencode($record->rewrite_url);
        $product->summary = strip_tags($record->presentation);
        $product->meta_title = $record->label;
        $product->meta_keywords = "";
        $product->meta_description = $record->presentation;
        $product->order = $record->rank;
        //save new categories
        $product->marchi_category_id = $category_id;
        $product->save();
        $product->newID = $product->id; //useful for filter when progress and later for prices
        $product->oldID = $record->id; //useful for filter when progress and later for prices
        return response()->json(['product' => $product]);
    }


    public function getMarchiPrices()
    {
        $content = Storage::disk('migrator')->get("marchiprices.json");
        $content = str_replace('"{', '{', $content);
        $content = str_replace('}"', '}', $content);
        $content = str_replace('\"', '"', $content);
        $content = json_decode($content);
        $finalContent = [];
        foreach ($content as $old) {
            $finalContent[] = $old;
        }
        return response()->json(['prices' => $finalContent]);
    }

    public function saveMarchiPrices(Request $request)
    {
        $record = json_decode($request->get("record"));
        $product_new_id = json_decode($request->get("product"));
        $price = new MarchiPrice();
        $price->day_date = $record->day_date;
        $price->price_min = $record->prix_min;
        $price->price_max = $record->prix_max;
        //save new product id
        $price->marchi_product_id = $product_new_id;
        $price->save();
        $price->newID = $price->id; //useful for filter when progress and later for prices
        return response()->json(['price' => $price]);
    }
}
