<?php

namespace App\Http\Controllers;

use App\KidsStory;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\KidsCategory;
use App\Http\Requests\CreateKidsStoryRequest;
use App\Http\Requests\UpdateKidsStoryRequest;

class KidsStoryController extends Controller
{
    /**
     * List Kids Stories
     * @return void
     */

    public function index()
    {
        $stories=KidsStory::latest("created_at")->paginate(10);
        return view('kids.list-stories')->with(compact("stories"));
    }

    /**
     * New Kids Story
     * @return void
     */
    public function newStory()
    {
        $categories = KidsCategory::get();
        return view('kids.create-story')->with(compact('categories'));
    }

    /**
     * Ajax Create new kids story
     * @return void
     */
    public function ajxNewStory(CreateKidsStoryRequest $request){
        $story = new KidsStory();
        $story->category_id = $request->get('category');
        $story->title = $request->get('title');
        $story->summary = $request->get('summary');
        $story->photo = $request->get('img');
        $story->youtube_url = $request->get('youtube_url');
        $story->url_rewrite = $request->get('title');
        $story->url_rewrite=str_replace(" ",'-',$story->url_rewrite);
        $story->url_rewrite=urlencode($story->url_rewrite);
        $storyCnt=KidsStory::where("url_rewrite","REGEXP","{$story->url_rewrite}(-[0-9]*)?$")->count();
        if($storyCnt>0){
            $story->url_rewrite=$story->url_rewrite."-".$storyCnt;
        }
        $story->save();
        return response()->json(['redirect'=>route('kidsStoriesList')]);
    }

    /**
     * Edit Kids Story
     * 
     * @param int $storyId
     * @return void
     */
    public function editStory($storyId){
        $story=KidsStory::find($storyId);
        $categories=KidsCategory::get();
        return view('kids.edit-story')->with(compact('categories'))->with(compact("story"));
    }

    /**
     * Ajax Edit kids Story
     * @return void
     */
    public function ajxUpdateStory(UpdateKidsStoryRequest $request,$storyId){
        $story = KidsStory::find($storyId);
        $story->category_id = $request->get('category');
        $story->title = $request->get('title');
        $story->summary = $request->get('summary');
        $story->photo = $request->get('img');
        $story->youtube_url = $request->get('youtube_url');
        $story->save();
        return response()->json(['redirect'=>route('kidsStoriesList')]);
    }

    /**
     * delete an article
     * 
     * @param int $storyId
     * @return void
     */
    public function deleteStory($storyId){
        $story=KidsStory::find($storyId);
        $story->delete();

        return response()->json(['redirect'=>route('kidsStoriesList')]);
    }
}
