<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Storage;
use Intervention\Image\Facades\Image;
use Carbon\Carbon;

use App\KidsCategory;
use App\KidsStory;

class KidsMigratorController extends Controller
{
    /**
     * migrator index page
     * 
     * @return void
     */
    public function index(){
        return view('migrator.kids');
    }

    /**
     * migrator get categories
     * 
     * @param Request $request
     * @return void
     */
    public function getCategories(Request $request){
        $content = Storage::disk('migrator')->get("kidscategories.json");
        $content=str_replace(",[]","",$content);
        $content=str_replace("[]","",$content);
        $content=str_replace(",,","",$content);
        $content=str_replace("\'","'",$content);
        $content=str_replace("&bdquo;","bdquo;",$content);
        $content=str_replace("[,","[",$content);
        $content=str_replace("&#39;","'",$content);
        $content=json_decode($content);
        //var_dump($content);
        $finalContent=[];
        foreach($content as $oldCategory){
            $oldCategory=json_decode($oldCategory);
            $category=new KidsCategory();
            $category->title=$oldCategory->label;
            $category->url_rewrite=$oldCategory->url_rewrite;

            $category->save();

            $oldCategory->newId=$category->id;
            $finalContent[]=$oldCategory;
            
        }

        return response()->json(['categories'=>$finalContent]);
    }

    /**
     * migrator stories
     * 
     * @return void
     */
    public function getStories(){
        $content = json_decode(Storage::disk('migrator')->get("kidsstories.json"));
        $content=str_replace(",[]","",$content);
        $content=str_replace("[]","",$content);
        $content=str_replace(",,","",$content);
        $content=str_replace("\'","'",$content);
        $content=str_replace("&bdquo;","bdquo;",$content);
        $content=str_replace("[,","[",$content);
        $content=str_replace("&#39;","'",$content);
        $finalContent=[];
        foreach($content as $old){
            $old=json_decode($old);
            $finalContent[]=$old;
        }
        return response()->json(['stories'=>$finalContent]);
    }

    /**
     * save story
     * 
     * @param Request $request
     * @return void
     */
    public function saveStory(Request $request){
        $content=$request->get("record");
        $content=str_replace(",[]","",$content);
        $content=str_replace("[]","",$content);
        $content=str_replace(",,","",$content);
        $content=str_replace("\'","'",$content);
        $content=str_replace("&bdquo;","bdquo;",$content);
        $content=str_replace("[,","[",$content);
        $content=str_replace("&#39;","'",$content);
        $record=json_decode($content);
        $category_id=$request->get("category");
        $story=new KidsStory();
        $story->title=$record->label;
        $story->category_id=$category_id;
        $story->summary=strip_tags($record->presentation);
        $story->photo = $record->photo;
        $story->youtube_url = $record->youtube_url;
        $story->url_rewrite = urlencode($record->rewrite_url);
        
        $story->save();

        try{
            

        }catch(\Exception $e){

        }

        $file=file_get_contents("http://old.diwanfm.net/upload/kids/".$record->photo);
            Storage::disk("frontoff")->put("photos/kids/".$record->photo,$file);


            $image=Image::make($file);
            $image->resize(220,null,function($constraint){
                $constraint->aspectRatio();
            });
            $image->crop(220,123,0,0);
            $image->save("../../diwanfm-frontoff/public/photos/kids/220x123-".$record->photo);



        $record->newStory=$story;
        $record->newID=$story->id;
        return response()->json(['story'=>$record]);
        
    }
}
