<?php

namespace App\Http\Controllers;

use App\Category;
use App\User;
use Carbon\Carbon;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;

class HomeController extends Controller
{
    /**
     * Create a new controller instance.
     *
     * @return void
     */
    public function __construct()
    {

    }

    /**
     * Show the application dashboard.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        return view('home');
    }

    public function statRedacteurs (){
        $start = (new Carbon('first day of this month'))->format('Y-m-d');
        $end = (new Carbon('last day of this month'))->format('Y-m-d');
        $auteurs = DB::table('role_user')->select('user_id')->distinct()->where('role_id', 2)->orWhere('role_id', 3)->get();

        $users = [];
        $array_categories = [];
        $total_categorie = 0;
        foreach($auteurs as $auteur){
            $user_categories = [];
            $user = User::find($auteur->user_id);

            $user->counter= [];
            $user->total =0;
            $posts = DB::table('posts')->select('id')
            ->where([['user_id', $auteur->user_id], ['published', '>=', $start], ['published', '<=', $end]])->get();

            foreach($posts as $post){
                $categories_post = DB::table('category_post')->select('category_id')->where('post_id', $post->id)->get();


                foreach($categories_post as $categorie_post){
                    $categorie = Category::find($categorie_post->category_id);

                    if (!isset($array_categories[$categorie->id])) {

                        $array_categories[$categorie->id] = $categorie;
                        $array_categories[$categorie->id]->total = 1;

                        if (!isset($user_categories[$categorie->id])){
                            $user_categories[$categorie->id] = 1;
                            (int)$user->total ++;
                        }else{
                            (int)$user_categories[$categorie->id] += 1;
                            (int)$user->total ++;
                        }

                    }else{
                        $array_categories[$categorie->id]->total += 1;
                        if (!isset($user_categories[$categorie->id])){
                            $user_categories[$categorie->id] = 1;
                            (int)$user->total ++;
                        }else{
                            (int)$user_categories[$categorie->id] += 1;
                            (int)$user->total ++;
                        }
                    }

                }

            }
            $user->counter= $user_categories;
            $total_categorie += $user->total;
            $users[$user->id] = $user;

        }

        return view('statRedacteurs')->with(compact('users', 'array_categories', 'total_categorie'));
    }

    public function statRedacteursFilter (Request $request){
        $start = Carbon::createFromFormat('m-yy', $request->datepicker)->startOfMonth()->toDateString();
        $end = Carbon::createFromFormat('m-yy', $request->datepicker)->endOfMonth()->toDateString();
        $auteurs = DB::table('role_user')->select('user_id')->distinct()->where('role_id', 2)->orWhere('role_id', 3)->get();

        $users = [];
        $array_categories = [];
        $total_categorie = 0;
        foreach($auteurs as $auteur){
            $user_categories = [];
            $user = User::find($auteur->user_id);

            $user->counter= [];
            $user->total =0;
            $posts = DB::table('posts')->select('id')
            ->where([['user_id', $auteur->user_id], ['published', '>=', $start], ['published', '<=', $end]])->get();

            foreach($posts as $post){
                $categories_post = DB::table('category_post')->select('category_id')->where('post_id', $post->id)->get();


                foreach($categories_post as $categorie_post){
                    $categorie = Category::find($categorie_post->category_id);

                    if (!isset($array_categories[$categorie->id])) {

                        $array_categories[$categorie->id] = $categorie;
                        $array_categories[$categorie->id]->total = 1;

                        if (!isset($user_categories[$categorie->id])){
                            $user_categories[$categorie->id] = 1;
                            (int)$user->total ++;
                        }else{
                            (int)$user_categories[$categorie->id] += 1;
                            (int)$user->total ++;
                        }

                    }else{
                        $array_categories[$categorie->id]->total += 1;
                        if (!isset($user_categories[$categorie->id])){
                            $user_categories[$categorie->id] = 1;
                            (int)$user->total ++;
                        }else{
                            (int)$user_categories[$categorie->id] += 1;
                            (int)$user->total ++;
                        }
                    }

                }

            }
            $user->counter= $user_categories;
            $total_categorie += $user->total;
            $users[$user->id] = $user;

        }

        return view('statRedacteurs')->with(compact('users', 'array_categories', 'total_categorie'));

    }
}
