<?php

namespace App\Http\Controllers;

use App\Configuration;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;

class ConfigurationController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $configurations = Configuration::get();
        return view("configurations.list")->with(compact("configurations"));
    }

     /**
     * edit the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  string $alias
     * @return \Illuminate\Http\Response
     */
    public function edit($alias){
        $config=Configuration::whereAlias($alias)->first();
        return view("configurations.edit")->with(compact("config"));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \App\string $alias
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $alias)
    {
        $config=Configuration::whereAlias($alias)->first();
        $config->value=$request->get('value');
        $config->save();

        return response()->json(['redirect'=>route('config')]);
    }
}
