<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Http\Requests\CreateCategoryRequest;
use App\Http\Requests\UpdateCategoryRequest;

use App\Category;
use App\SitemapIndex;
use App\SitemapLink;

class CategoryController extends Controller
{
    /**
     * Create a new controller instance.
     *
     * @return void
     */
    public function __construct()
    {

    }

    /**
     * categories list
     *
     * @return void
     */
    public function index(){
        $categories=Category::get();
        return view('categories.list')->with(compact('categories'));
    }

    /**
     * new category form
     *
     * @return void
     */
    public function newCategory(){
        $categories=Category::get();
        return view('categories.create')->with(compact('categories'));
    }

    /**
     * create new category ajax request
     *
     * @param Request $request
     * @return void
     */
    public function ajxNewCategory(CreateCategoryRequest $request){
        $category=new Category();
        $category->title=$request->get("title");
        $category->meta_title=$request->get("meta_title");
        $category->keywords=$request->get("keywords");
        $category->news_keywords=$request->get("news_keywords");
        $category->description=$request->get("description");
        $category->parent_id=$request->get("parent");
        $category->habillage_link=$request->get("habillage_link");
        $category->habillage=$request->get("habillage");
        $category->color=$request->get("color");

        $alias=$request->get("title");
        $alias=str_replace(" ",'-',$alias);
        $alias=urlencode($alias);
        $category->url_rewrite=$alias;
        $category->save();

        $sitemapLink = new SitemapLink();
        $url = $sitemapLink->getRoutLink(2).$category->url_rewrite;
        $sitemapLink->InsertSitemapLink(2,$category->id,$url);

        $sitemapLink = new SitemapLink();
        $url = $sitemapLink->getRoutLink(3).$category->url_rewrite;
        $sitemapLink->InsertSitemapLink(3,$category->id,$url);

        return response()->json(['redirect'=>route('categoriesList')]);
    }

    /**
     * edit category form
     *
     * @param int $categoryId
     * @return void
     */
    public function edit($categoryId)
    {
        $category=Category::find($categoryId);
        $categories=Category::where("id","<>",$categoryId)->get();
        return view('categories.edit')
        ->with(compact("category"))
        ->with(compact("categories"));
    }

    /**
     * update category
     *
     * @param UpdateCategoryRequest $request
     * @param int $categoryId
     * @return void
     */
    public function ajxUpdateCategory(UpdateCategoryRequest $request,$categoryId){
        $category=Category::find($categoryId);

        $category->title=$request->get("title");
        $category->meta_title=$request->get("meta_title");
        $category->keywords=$request->get("keywords");
        $category->news_keywords=$request->get("news_keywords");
        $category->description=$request->get("description");
        $category->parent_id=$request->get("parent");
        $category->habillage_link=$request->get("habillage_link");
        $category->habillage=$request->get("habillage");
        $category->color=$request->get("color");
        $category->isActive=$request->get("isActive");

        $category->save();

        // update sitmap link
        $sitemapLink = new SitemapLink();
        $sitemapLink->UpdateSitemapLink(2,$category->id);

        // update sitmap link
        $sitemapLink = new SitemapLink();
        $sitemapLink->UpdateSitemapLink(3,$category->id);

        return response()->json(['redirect'=>route('categoriesList')]);
    }

    /**
     * delete a category
     *
     * @param int $categoryId
     * @return void
     */
    public function delete($categoryId){
        $category=Category::find($categoryId);

        // delete sitmap link
        $sitemapLink = new SitemapLink();
        $sitemapLink->DeleteSitemapLink(2, $category->id);

        // delete sitmap link
        $sitemapLink = new SitemapLink();
        $sitemapLink->DeleteSitemapLink(3, $category->id);

        $category->delete();

        return response()->json(['redirect'=>route('categoriesList')]);
    }
}
