<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Http\Requests\CreateAnimatorRequest;
use App\Http\Requests\UpdateAnimatorRequest;
use App\SitemapIndex;
use App\SitemapLink;

use App\Animator;

class AnimatorController extends Controller
{
    /**
     * Create a new controller instance.
     *
     * @return void
     */
    public function __construct()
    {

    }

    /**
     * animators list
     *
     * @return void
     */
    public function index(){
        $animators=Animator::latest("created_at")->paginate(100);
        return view('animators.list')->with(compact('animators'));
    }

    /**
     * new animator form
     *
     * @return void
     */
    public function newAnimator(){
        return view('animators.create');
    }

    /**
     * create new animator ajax request
     *
     * @param Request $request
     * @return void
     */
    public function ajxNewAnimator(CreateAnimatorRequest $request){
        $animator=new Animator();
        $animator->name=$request->get("name");
        $animator->description=$request->get("description");
        $animator->meta_description=$request->get("meta_description");
        $animator->meta_keywords=$request->get("meta_keywords");
        $animator->img=$request->get("img");
        $animator->img_alt=$request->get("img_alt");
        $animator->public=$request->get("public");
        $animator->tag=$request->get("tag");
        $animator->role=$request->get("role");
        $alias=$request->get("name");
        $alias=str_replace(" ",'-',$alias);
        $alias=str_replace("/",'-',$alias);
        $alias=urlencode($alias);
        $animator->url_rewrite=$alias;
        $animator->save();

        $sitemapLink = new SitemapLink();
        $url = $sitemapLink->getRoutLink(6).$animator->url_rewrite;
        $sitemapLink->InsertSitemapLink(6,$animator->id,$url);

        return response()->json(['redirect'=>route('animatorsList')]);
    }

    /**
     * edit animator
     *
     * @param int $animatorId
     * @return void
     */
    public function edit($animatorId){
        $animator=Animator::find($animatorId);
        return view('animators.edit')->with(compact("animator"));
    }

    /**
     * update animator ajax request
     *
     * @param UpdateAnimatorRequest $request
     * @param int $animatorId
     *
     * @return void
     */
    public function ajxUpdateAnimator(UpdateAnimatorRequest $request,$animatorId){
        $animator=Animator::find($animatorId);

        $animator->name=$request->get("name");
        $animator->description=$request->get("description");
        $animator->meta_description=$request->get("meta_description");
        $animator->meta_keywords=$request->get("meta_keywords");
        $animator->img=$request->get("img");
        $animator->img_alt=$request->get("img_alt");
        $animator->public=$request->get("public");
        $animator->tag=$request->get("tag");
        $animator->role=$request->get("role");
        $animator->save();

        // update sitmap link
        $sitemapLink = new SitemapLink();
        $sitemapLink->UpdateSitemapLink(6,$animator->id);

        return response()->json(['redirect'=>route('animatorsList')]);
    }

    /**
     * delete animator
     *
     * @param int $animatorId
     * @return void
     */
    public function delete($animatorId){
        $animator=Animator::find($animatorId);

        // delete sitmap link
        $sitemapLink = new SitemapLink();
        $sitemapLink->DeleteSitemapLink(6, $animator->id);

        $animator->delete();

        return response()->json(['redirect'=>route('animatorsList')]);
    }
}
