<?php

namespace App\Http\Controllers;

use App\Ads;
use Illuminate\Support\Facades\Storage;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Http\Requests\UpdateAdsRequest;

class AdsController extends Controller
{
    /**
     * List Ads
     * @return void
     */
    public function index(){
        $ads = Ads::get();
        return view("ads.list-ads")->with(compact("ads"));
    }

    public function editAds($adsId){
        $ads=Ads::find($adsId);
        $filename = $adsId."-pub.txt";
        $content = Storage::disk('public')->get($filename);
        return view("ads.edit-ads")->with(compact("content"))->with(compact("ads"));
    }

    public function ajxUpdateAds(UpdateAdsRequest $request,$adsId){
        $ads = Ads::find($adsId);
        $ads->title = $request->get('title');
        $ads->save();

        $content = $request->get('content');
        $filename = $adsId."-pub.txt";
        Storage::disk('public')->put($filename, $content);
        
        return response()->json(['redirect'=>route('AdsList')]);
    }

}
