<?php

namespace App;

use Illuminate\Database\Eloquent\Model;

class Category extends Model
{
     /**
     * The attributes that are mass assignable.
     *
     * @var array
     */
    protected $fillable = [
        'title', 'url_rewrite', 'keywords','news_keywords','meta_title','description','habillage','habillage_link','color', 'isActive'
    ];

    public function childrens(){
        return $this->hasMany(Category::class,'parent_id','id');
    }

    public function parent(){
        return $this->belongsTo(Category::class,'parent_id');
    }

    public function posts(){
        return $this->belongsToMany(Post::class);
    }

    public function getParent(){
        if(!$this->getAttribute('parent_id')){
            return null;
        }else{
            return $this->getAttribute('parent');
        }
    }
}
