<?php

namespace App;

use Illuminate\Database\Eloquent\Model;

class Animator extends Model
{
    /**
     * The attributes that are mass assignable.
     *
     * @var array
     */
    protected $fillable = [
        'name',
        'description',
        'meta_description',
        'meta_keywords',
        'url_rewrite',
        'img',
        'img_alt',
        'public',
        'role'
    ];

    public function programs(){
        return $this->hasMany(Program::class);
    }

    public function podcasts(){
        return $this->belongsToMany(Program::class);
    }
}
